/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.comment;

import com.atlassian.bitbucket.comment.CommentSeverity;
import com.atlassian.bitbucket.comment.Commentable;
import com.atlassian.bitbucket.util.BuilderSupport;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;

public class AddCommentRequest {
    private final Commentable commentable;
    private final boolean pending;
    private final CommentSeverity severity;
    private final String text;

    protected AddCommentRequest(@Nonnull AbstractBuilder builder) {
        this.commentable = builder.commentable;
        this.pending = builder.pending;
        this.severity = builder.severity;
        this.text = builder.text;
    }

    @Nonnull
    public Commentable getCommentable() {
        return this.commentable;
    }

    @Nullable
    public CommentSeverity getSeverity() {
        return this.severity;
    }

    @Nonnull
    public String getText() {
        return this.text;
    }

    public boolean isPending() {
        return this.pending;
    }

    public static abstract class AbstractBuilder<B extends AbstractBuilder<B, R>, R extends AddCommentRequest>
    extends BuilderSupport {
        private final Commentable commentable;
        private final String text;
        private boolean pending;
        private CommentSeverity severity;

        public AbstractBuilder(@Nonnull Commentable commentable, @Nonnull String text) {
            this.commentable = Objects.requireNonNull(commentable, "commentable");
            this.text = AbstractBuilder.requireNonBlank(text, "text");
        }

        @Nonnull
        public abstract R build();

        @Nonnull
        public B pending(boolean value) {
            this.pending = value;
            return this.self();
        }

        @Nonnull
        public B severity(@Nullable CommentSeverity value) {
            this.severity = value;
            return this.self();
        }

        @Nonnull
        protected abstract B self();
    }

    public static class Builder
    extends AbstractBuilder<Builder, AddCommentRequest> {
        public Builder(@Nonnull Commentable commentable, @Nonnull String text) {
            super(commentable, text);
        }

        @Override
        @Nonnull
        public AddCommentRequest build() {
            return new AddCommentRequest(this);
        }

        @Override
        @Nonnull
        public Builder self() {
            return this;
        }
    }
}

