/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.comment;

import com.atlassian.bitbucket.comment.AddFileCommentRequest;
import com.atlassian.bitbucket.comment.CommentThreadDiffAnchorType;
import com.atlassian.bitbucket.comment.Commentable;
import com.atlassian.bitbucket.content.DiffFileType;
import com.atlassian.bitbucket.content.DiffSegmentType;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public class AddLineCommentRequest
extends AddFileCommentRequest {
    private final DiffFileType fileType;
    private final int line;
    private final DiffSegmentType lineType;

    protected AddLineCommentRequest(AbstractLineCommentRequestBuilder builder) {
        super(builder);
        Preconditions.checkArgument((builder.line != 0 ? 1 : 0) != 0, (Object)"line");
        this.fileType = Objects.requireNonNull(builder.fileType, "fileType");
        this.line = builder.line;
        this.lineType = Objects.requireNonNull(builder.lineType, "lineType");
    }

    @Nonnull
    public DiffFileType getFileType() {
        return this.fileType;
    }

    public int getLine() {
        return this.line;
    }

    @Nonnull
    public DiffSegmentType getLineType() {
        return this.lineType;
    }

    protected static abstract class AbstractLineCommentRequestBuilder<B extends AbstractLineCommentRequestBuilder<B, R>, R extends AddFileCommentRequest>
    extends AddFileCommentRequest.AbstractFileBuilder<B, R> {
        private DiffFileType fileType;
        private int line = 0;
        private DiffSegmentType lineType;

        public AbstractLineCommentRequestBuilder(@Nonnull Commentable commentable, @Nonnull String text, @Nonnull CommentThreadDiffAnchorType diffType, @Nonnull String path) {
            super(commentable, text, diffType, path);
        }

        @Nonnull
        public B fileType(@Nonnull DiffFileType value) {
            this.fileType = Objects.requireNonNull(value, "fileType");
            return (B)((AbstractLineCommentRequestBuilder)this.self());
        }

        @Nonnull
        public B line(int value) {
            Preconditions.checkArgument((value > 0 ? 1 : 0) != 0, (String)"Line must be > %s (Rejected: %s)", (int)0, (int)value);
            this.line = value;
            return (B)((AbstractLineCommentRequestBuilder)this.self());
        }

        @Nonnull
        public B lineType(@Nonnull DiffSegmentType value) {
            this.lineType = Objects.requireNonNull(value, "lineType");
            return (B)((AbstractLineCommentRequestBuilder)this.self());
        }
    }

    public static class Builder
    extends AbstractLineCommentRequestBuilder<Builder, AddLineCommentRequest> {
        public Builder(@Nonnull Commentable commentable, @Nonnull String text, @Nonnull CommentThreadDiffAnchorType diffType, @Nonnull String path) {
            super(commentable, text, diffType, path);
        }

        @Override
        @Nonnull
        public AddLineCommentRequest build() {
            return new AddLineCommentRequest(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

