/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.comment;

import com.atlassian.bitbucket.comment.Comment;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import jakarta.annotation.Nonnull;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class CommentChain<C extends Comment>
implements Iterable<C> {
    private final List<C> rootComments;

    private CommentChain(@Nonnull Iterable<C> rootComments) {
        this.rootComments = ImmutableList.copyOf(Objects.requireNonNull(rootComments, "rootComments"));
    }

    public static <C extends Comment> CommentChain<C> of(@Nonnull Iterable<C> rootComments) {
        return new CommentChain<C>(rootComments);
    }

    @Nonnull
    public Stream<C> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    @Override
    @Nonnull
    public Iterator<C> iterator() {
        return new DepthFirstIterator(this);
    }

    private class DepthFirstIterator
    implements Iterator<C> {
        private final Deque<C> commentStack = new LinkedList();

        DepthFirstIterator(CommentChain commentChain) {
            this.pushAll(commentChain.rootComments);
        }

        @Override
        public boolean hasNext() {
            return !this.commentStack.isEmpty();
        }

        @Override
        public C next() {
            Comment currentComment = (Comment)this.commentStack.pop();
            this.pushAll(currentComment.getComments());
            return currentComment;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Element removal is not supported by " + this.getClass().getName());
        }

        private void pushAll(List<C> comments) {
            for (Comment comment : Lists.reverse(comments)) {
                this.commentStack.push(comment);
            }
        }
    }
}

