/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.comment;

import com.atlassian.bitbucket.comment.CommentSeverity;
import com.atlassian.bitbucket.comment.CommentState;
import com.atlassian.bitbucket.comment.CommentThreadDiffAnchorState;
import com.atlassian.bitbucket.comment.CommentThreadDiffAnchorType;
import com.atlassian.bitbucket.comment.Commentable;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.Set;

public class CommentSearchRequest {
    private final CommentThreadDiffAnchorState anchorState;
    private final ApplicationUser author;
    private final Commentable commentable;
    private final Set<CommentThreadDiffAnchorType> diffTypes;
    private final String fromHash;
    private final String path;
    private final Set<CommentSeverity> severities;
    private final Set<CommentState> states;
    private final String toHash;

    private CommentSearchRequest(@Nonnull Builder builder) {
        this.anchorState = builder.anchorState;
        this.author = builder.author;
        this.commentable = builder.commentable;
        this.diffTypes = builder.diffTypes.build();
        this.fromHash = builder.fromHash;
        this.path = builder.path;
        this.severities = builder.severities.build();
        this.states = builder.states.build();
        this.toHash = builder.toHash;
    }

    @Nonnull
    public CommentThreadDiffAnchorState getAnchorState() {
        return this.anchorState;
    }

    @Nullable
    public ApplicationUser getAuthor() {
        return this.author;
    }

    @Nonnull
    public Commentable getCommentable() {
        return this.commentable;
    }

    @Nonnull
    public Set<CommentThreadDiffAnchorType> getDiffTypes() {
        return this.diffTypes;
    }

    @Nullable
    public String getFromHash() {
        return this.fromHash;
    }

    @Nullable
    public String getPath() {
        return this.path;
    }

    @Nonnull
    public Set<CommentSeverity> getSeverities() {
        return this.severities;
    }

    @Nonnull
    public Set<CommentState> getStates() {
        return this.states;
    }

    @Nullable
    public String getToHash() {
        return this.toHash;
    }

    public static class Builder
    extends BuilderSupport {
        private final Commentable commentable;
        private final ImmutableSet.Builder<CommentThreadDiffAnchorType> diffTypes;
        private final ImmutableSet.Builder<CommentSeverity> severities;
        private final ImmutableSet.Builder<CommentState> states;
        private CommentThreadDiffAnchorState anchorState;
        private ApplicationUser author;
        private String fromHash;
        private String path;
        private String toHash;

        public Builder(@Nonnull Commentable commentable) {
            this.commentable = Objects.requireNonNull(commentable, "commentable");
            this.anchorState = CommentThreadDiffAnchorState.ACTIVE;
            this.diffTypes = ImmutableSet.builder();
            this.severities = ImmutableSet.builder();
            this.states = ImmutableSet.builder();
        }

        @Nonnull
        public Builder anchorState(@Nonnull CommentThreadDiffAnchorState value) {
            this.anchorState = Objects.requireNonNull(value, "anchorState");
            return this;
        }

        @Nonnull
        public Builder author(@Nullable ApplicationUser value) {
            this.author = Objects.requireNonNull(value, "author");
            return this;
        }

        @Nonnull
        public CommentSearchRequest build() {
            return new CommentSearchRequest(this);
        }

        @Nonnull
        public Builder diffType(@Nullable CommentThreadDiffAnchorType value) {
            Builder.addIf(Objects::nonNull, this.diffTypes, value);
            return this;
        }

        @Nonnull
        public Builder diffTypes(@Nullable Iterable<CommentThreadDiffAnchorType> values) {
            Builder.addIf(Objects::nonNull, this.diffTypes, values);
            return this;
        }

        @Nonnull
        public Builder fromHash(@Nullable String value) {
            this.fromHash = value;
            return this;
        }

        @Nonnull
        public Builder path(@Nullable String value) {
            this.path = value;
            return this;
        }

        @Nonnull
        public Builder severities(@Nullable Iterable<CommentSeverity> values) {
            Builder.addIf(Objects::nonNull, this.severities, values);
            return this;
        }

        @Nonnull
        public Builder severity(@Nullable CommentSeverity value) {
            Builder.addIf(Objects::nonNull, this.severities, value);
            return this;
        }

        @Nonnull
        public Builder state(@Nullable CommentState value) {
            Builder.addIf(Objects::nonNull, this.states, value);
            return this;
        }

        @Nonnull
        public Builder states(@Nullable Iterable<CommentState> values) {
            Builder.addIf(Objects::nonNull, this.states, values);
            return this;
        }

        @Nonnull
        public Builder toHash(@Nullable String value) {
            this.toHash = value;
            return this;
        }
    }
}

