/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.comment;

import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public record LineNumberRange(int minimum, int maximum) {
    public LineNumberRange {
        Preconditions.checkArgument((minimum > 0 ? 1 : 0) != 0, (Object)"Minimum line number must be greater than 0");
        Preconditions.checkArgument((maximum > 0 ? 1 : 0) != 0, (Object)"Maximum line number must be greater than 0");
        Preconditions.checkArgument((minimum <= maximum ? 1 : 0) != 0, (Object)"Provided range contains no elements");
    }

    public boolean contains(int lineNumber) {
        return lineNumber >= this.minimum && lineNumber <= this.maximum;
    }

    public boolean isSingleLine() {
        return this.maximum == this.minimum;
    }

    public boolean overlaps(@Nonnull LineNumberRange otherRange) {
        Objects.requireNonNull(otherRange, "otherRange");
        return otherRange.maximum >= this.minimum && otherRange.minimum <= this.maximum;
    }
}

