/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.commit;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.BuilderSupport;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;

public abstract class AbstractCommitRequest {
    public static final int UNLIMITED_MESSAGE_LENGTH = -1;
    private final String commitId;
    private final int maxMessageLength;
    private final String path;
    private final Repository repository;

    protected AbstractCommitRequest(AbstractCommitRequestBuilder<?> builder) {
        this.commitId = builder.commitId;
        this.path = builder.path;
        this.repository = builder.repository;
        this.maxMessageLength = builder.maxMessageLength;
    }

    @Nonnull
    public String getCommitId() {
        return this.commitId;
    }

    public int getMaxMessageLength() {
        return this.maxMessageLength;
    }

    @Nullable
    public String getPath() {
        return this.path;
    }

    @Nonnull
    public Repository getRepository() {
        return this.repository;
    }

    public static abstract class AbstractCommitRequestBuilder<B extends AbstractCommitRequestBuilder<B>>
    extends BuilderSupport {
        private final String commitId;
        private final Repository repository;
        private int maxMessageLength;
        private String path;

        protected AbstractCommitRequestBuilder(@Nonnull Repository repository, @Nonnull String commitId) {
            this.commitId = AbstractCommitRequestBuilder.requireNonBlank(commitId, "commitId");
            this.repository = Objects.requireNonNull(repository, "repository");
            this.maxMessageLength = -1;
        }

        @Nonnull
        public B maxMessageLength(int value) {
            this.maxMessageLength = value;
            return this.self();
        }

        @Nonnull
        public B path(@Nullable String value) {
            this.path = value;
            return this.self();
        }

        protected abstract B self();
    }
}

