/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.commit;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.Set;

public class CommonAncestorRequest {
    private final Set<String> commitIds;
    private final Repository repository;
    private final Repository secondaryRepository;

    private CommonAncestorRequest(Builder builder) {
        this.commitIds = builder.commitIds.build();
        Preconditions.checkArgument((this.commitIds.size() > 0 ? 1 : 0) != 0, (Object)"Must specify at least 1 commit ID");
        this.repository = builder.repository;
        this.secondaryRepository = builder.secondaryRepository;
    }

    @Nonnull
    public Set<String> getCommitIds() {
        return this.commitIds;
    }

    @Nonnull
    public Repository getRepository() {
        return this.repository;
    }

    @Nullable
    public Repository getSecondaryRepository() {
        return this.secondaryRepository;
    }

    public static class Builder
    extends BuilderSupport {
        private final ImmutableSet.Builder<String> commitIds;
        private final Repository repository;
        private Repository secondaryRepository;

        public Builder(@Nonnull Repository repository) {
            this.repository = Objects.requireNonNull(repository, "repository");
            this.commitIds = ImmutableSet.builder();
        }

        @Nonnull
        public CommonAncestorRequest build() {
            return new CommonAncestorRequest(this);
        }

        @Nonnull
        public Builder commitId(@Nullable String value, String ... moreValues) {
            Builder.addIf(Objects::nonNull, this.commitIds, value, moreValues);
            return this;
        }

        @Nonnull
        public Builder commitId(@Nullable Iterable<String> values) {
            Builder.addIf(Objects::nonNull, this.commitIds, values);
            return this;
        }

        @Nonnull
        public Builder secondaryRepository(@Nullable Repository value) {
            this.secondaryRepository = value;
            return this;
        }
    }
}

