/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.commit;

import com.atlassian.bitbucket.util.BuilderSupport;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Optional;

public class LastModifiedContext {
    private final String commitId;
    private final String path;

    private LastModifiedContext(Builder builder) {
        this.commitId = builder.commitId;
        this.path = builder.path;
    }

    @Nonnull
    public String getCommitId() {
        return this.commitId;
    }

    @Nonnull
    public Optional<String> getPath() {
        return Optional.ofNullable(this.path);
    }

    public static class Builder
    extends BuilderSupport {
        private final String commitId;
        private String path;

        public Builder(@Nonnull String commitId) {
            this.commitId = Builder.requireNonBlank(commitId, "commitId");
        }

        @Nonnull
        public LastModifiedContext build() {
            return new LastModifiedContext(this);
        }

        @Nonnull
        public Builder path(@Nullable String value) {
            this.path = value;
            return this;
        }
    }
}

