/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.commit;

import com.atlassian.bitbucket.commit.Changeset;
import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.commit.MinimalCommit;
import com.atlassian.bitbucket.content.Change;
import com.atlassian.bitbucket.util.Page;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;

public class SimpleChangeset
implements Changeset {
    private final MinimalCommit fromCommit;
    private final Commit toCommit;
    private final Page<Change> changes;

    private SimpleChangeset(Builder builder) {
        this.fromCommit = builder.fromCommit;
        this.toCommit = builder.toCommit;
        this.changes = builder.changes;
    }

    @Override
    public Page<Change> getChanges() {
        return this.changes;
    }

    @Override
    public MinimalCommit getFromCommit() {
        return this.fromCommit;
    }

    @Override
    @Nonnull
    public Commit getToCommit() {
        return this.toCommit;
    }

    public static class Builder {
        private final Commit toCommit;
        private Page<Change> changes;
        private MinimalCommit fromCommit;

        public Builder(@Nonnull Commit toCommit) {
            this.toCommit = Objects.requireNonNull(toCommit, "toCommit");
        }

        @Nonnull
        public SimpleChangeset build() {
            return new SimpleChangeset(this);
        }

        @Nonnull
        public Builder changes(@Nullable Page<Change> value) {
            this.changes = value;
            return this;
        }

        @Nonnull
        public Builder fromCommit(@Nullable MinimalCommit value) {
            this.fromCommit = value;
            return this;
        }
    }
}

