/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.commit;

import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.commit.MinimalCommit;
import com.atlassian.bitbucket.commit.SimpleMinimalCommit;
import com.atlassian.bitbucket.property.PropertyMap;
import com.atlassian.bitbucket.property.SimplePropertySupport;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.Person;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class SimpleCommit
extends SimpleMinimalCommit
implements Commit,
Serializable {
    private final Person author;
    private final Date authorTimestamp;
    private final Person committer;
    private final Date committerTimestamp;
    private final String message;
    private final List<MinimalCommit> parents;
    private transient SimplePropertySupport propertySupport;
    private transient Repository repository;

    private SimpleCommit(Builder builder) {
        super(builder.minimalCommitBuilder);
        this.author = Objects.requireNonNull(builder.author == null ? builder.committer : builder.author, "author");
        this.authorTimestamp = Objects.requireNonNull(builder.authorTimestamp == null ? builder.committerTimestamp : builder.authorTimestamp, "authorTimestamp");
        this.committer = (Person)MoreObjects.firstNonNull((Object)builder.committer, (Object)builder.author);
        this.committerTimestamp = (Date)MoreObjects.firstNonNull((Object)builder.committerTimestamp, (Object)builder.authorTimestamp);
        this.message = builder.message;
        this.parents = ImmutableList.copyOf(builder.parents);
        this.propertySupport = new SimplePropertySupport(builder);
        this.repository = builder.repository;
    }

    @Override
    public boolean equals(Object o) {
        if (super.equals(o) && o instanceof SimpleCommit) {
            SimpleCommit that = (SimpleCommit)o;
            return Objects.equals(this.getAuthor(), that.getAuthor()) && Objects.equals(this.getAuthorTimestamp(), that.getAuthorTimestamp()) && Objects.equals(this.getMessage(), that.getMessage());
        }
        return false;
    }

    @Override
    @Nonnull
    public Person getAuthor() {
        return this.author;
    }

    @Override
    @Nonnull
    public Date getAuthorTimestamp() {
        return this.authorTimestamp;
    }

    @Override
    @Nonnull
    public Person getCommitter() {
        return this.committer;
    }

    @Override
    @Nonnull
    public Date getCommitterTimestamp() {
        return this.committerTimestamp;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Nonnull
    public List<MinimalCommit> getParents() {
        return this.parents;
    }

    @Override
    @Nonnull
    public PropertyMap getProperties() {
        return this.propertySupport.getProperties();
    }

    @Override
    public Repository getRepository() {
        return this.repository;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getId(), this.getAuthor(), this.getAuthorTimestamp(), this.getMessage());
    }

    public void setProperties(@Nonnull PropertyMap properties) {
        this.propertySupport.setProperties(properties);
    }

    public void setRepository(Repository repository) {
        if (this.repository != null) {
            throw new IllegalStateException("Repository has already been set; you cannot override once set.");
        }
        this.repository = repository;
    }

    @Override
    public String toString() {
        return "SimpleCommit{id='" + this.getId() + "', author='" + String.valueOf(this.getAuthor()) + "', authorTimestamp=" + String.valueOf(this.getAuthorTimestamp()) + "', committer='" + String.valueOf(this.getCommitter()) + "', committerTimestamp=" + String.valueOf(this.getCommitterTimestamp()) + ", message='" + this.getMessage() + "'}";
    }

    public static final class Builder
    extends SimplePropertySupport.AbstractPropertyBuilder<Builder> {
        private final SimpleMinimalCommit.Builder minimalCommitBuilder;
        private Person author;
        private Date authorTimestamp;
        private Person committer;
        private Date committerTimestamp;
        private String message;
        private List<MinimalCommit> parents;
        private Repository repository;

        public Builder(@Nonnull String id) {
            this.minimalCommitBuilder = new SimpleMinimalCommit.Builder(id);
            this.parents = new ArrayList<MinimalCommit>();
        }

        public Builder(@Nonnull Commit commit) {
            super(commit);
            this.author = commit.getAuthor();
            this.authorTimestamp = commit.getAuthorTimestamp();
            this.committer = commit.getCommitter();
            this.committerTimestamp = commit.getCommitterTimestamp();
            this.message = commit.getMessage();
            this.minimalCommitBuilder = new SimpleMinimalCommit.Builder(commit);
            this.parents = new ArrayList<MinimalCommit>(commit.getParents());
            this.repository = commit.getRepository();
        }

        @Nonnull
        public Builder author(@Nonnull Person value) {
            this.author = Objects.requireNonNull(value, "author");
            return this.self();
        }

        @Nonnull
        public Builder authorTimestamp(@Nullable Date value) {
            this.authorTimestamp = value == null ? null : new Date(value.getTime());
            return this.self();
        }

        @Nonnull
        public SimpleCommit build() {
            return new SimpleCommit(this);
        }

        @Nonnull
        public Builder clearParents() {
            this.parents.clear();
            return this.self();
        }

        @Nonnull
        public Builder committer(@Nonnull Person value) {
            this.committer = Objects.requireNonNull(value, "committer");
            return this.self();
        }

        @Nonnull
        public Builder committerTimestamp(@Nullable Date value) {
            this.committerTimestamp = value == null ? null : new Date(value.getTime());
            return this.self();
        }

        @Nonnull
        public Builder displayId(@Nullable String value) {
            this.minimalCommitBuilder.displayId(value);
            return this.self();
        }

        @Nonnull
        public Builder message(@Nullable String value) {
            this.message = value;
            return this.self();
        }

        @Nonnull
        public Builder parent(@Nullable MinimalCommit value) {
            Builder.addIf(Objects::nonNull, this.parents, value);
            return this.self();
        }

        @Nonnull
        public Builder parents(@Nullable MinimalCommit value, MinimalCommit ... values) {
            Builder.addIf(Objects::nonNull, this.parents, value, values);
            return this.self();
        }

        @Nonnull
        public Builder parents(@Nullable Iterable<MinimalCommit> values) {
            Builder.addIf(Objects::nonNull, this.parents, values);
            return this.self();
        }

        @Nonnull
        public Builder repository(@Nullable Repository value) {
            this.repository = value;
            return this.self();
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

