/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.compare;

import com.atlassian.bitbucket.compare.CompareRef;
import com.atlassian.bitbucket.content.DiffWhitespace;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.Set;

public class CompareDiffStatsSummaryRequest
extends BuilderSupport {
    private final CompareRef fromRef;
    private final Set<String> paths;
    private final CompareRef toRef;
    private final DiffWhitespace whitespace;

    private CompareDiffStatsSummaryRequest(@Nonnull Builder builder) {
        this.fromRef = builder.fromRef;
        this.paths = builder.paths.build();
        this.toRef = builder.toRef;
        this.whitespace = builder.whitespace;
    }

    @Nonnull
    public CompareRef getFromRef() {
        return this.fromRef;
    }

    @Nonnull
    public Set<String> getPaths() {
        return this.paths;
    }

    @Nonnull
    public CompareRef getToRef() {
        return this.toRef;
    }

    @Nonnull
    public DiffWhitespace getWhitespace() {
        return this.whitespace;
    }

    public static class Builder {
        private final ImmutableSet.Builder<String> paths = ImmutableSet.builder();
        private CompareRef fromRef;
        private CompareRef toRef;
        private DiffWhitespace whitespace = DiffWhitespace.SHOW;

        @Nonnull
        public CompareDiffStatsSummaryRequest build() {
            Preconditions.checkArgument((this.fromRef != null && this.toRef != null ? 1 : 0) != 0, (Object)"both a from and to ref are required");
            return new CompareDiffStatsSummaryRequest(this);
        }

        @Nonnull
        public Builder fromRef(@Nonnull CompareRef fromRef) {
            this.fromRef = Objects.requireNonNull(fromRef, "fromRef");
            return this;
        }

        @Nonnull
        public Builder paths(@Nullable String value, String ... values) {
            CompareDiffStatsSummaryRequest.addIf(NOT_BLANK, this.paths, value, values);
            return this;
        }

        @Nonnull
        public Builder toRef(@Nonnull CompareRef toRef) {
            this.toRef = Objects.requireNonNull(toRef, "toRef");
            return this;
        }

        @Nonnull
        public Builder whitespace(@Nonnull DiffWhitespace value) {
            this.whitespace = Objects.requireNonNull(value, "value");
            return this;
        }
    }
}

