/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.content;

import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;

public enum ArchiveFormat {
    TAR("tar"),
    TAR_GZ("tar.gz", "tgz"),
    ZIP("zip");

    private final String defaultExtension;
    private final Set<String> extensions;

    private ArchiveFormat(String ... extensions) {
        this.extensions = ImmutableSet.copyOf((Object[])extensions);
        this.defaultExtension = extensions[0];
    }

    @Nonnull
    public static ArchiveFormat fromExtension(@Nonnull String extension) {
        String filterExtension = Objects.requireNonNull(extension, "extension").toLowerCase(Locale.ROOT);
        return Stream.of(ArchiveFormat.values()).filter(format -> format.getExtensions().contains(filterExtension)).findFirst().orElseThrow(() -> new IllegalArgumentException("No ArchiveFormat is associated with extension [" + extension + "]"));
    }

    @Nonnull
    public String getDefaultExtension() {
        return this.defaultExtension;
    }

    @Nonnull
    public Set<String> getExtensions() {
        return this.extensions;
    }
}

