/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.content;

import com.atlassian.bitbucket.content.ArchiveFormat;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class ArchiveRequest {
    private final String commitId;
    private final ArchiveFormat format;
    private final Set<String> paths;
    private final String prefix;
    private final Repository repository;

    private ArchiveRequest(Builder builder) {
        this.commitId = builder.commitId;
        this.format = builder.format;
        this.paths = builder.paths.build();
        this.prefix = StringUtils.appendIfMissing((String)builder.prefix, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        this.repository = builder.repository;
    }

    @Nonnull
    public String getCommitId() {
        return this.commitId;
    }

    @Nonnull
    public ArchiveFormat getFormat() {
        return this.format;
    }

    @Nonnull
    public Set<String> getPaths() {
        return this.paths;
    }

    @Nonnull
    public Optional<String> getPrefix() {
        return Optional.ofNullable(this.prefix);
    }

    @Nonnull
    public Repository getRepository() {
        return this.repository;
    }

    public static class Builder
    extends BuilderSupport {
        private final String commitId;
        private final ImmutableSet.Builder<String> paths;
        private final Repository repository;
        private ArchiveFormat format;
        private String prefix;

        public Builder(@Nonnull ArchiveRequest request) {
            this(Objects.requireNonNull(request, "request").getRepository(), request.getCommitId());
            this.format(request.getFormat()).paths(request.getPaths()).prefix(request.getPrefix().orElse(null));
        }

        public Builder(@Nonnull Repository repository, @Nonnull String commitId) {
            this.repository = Objects.requireNonNull(repository, "repository");
            this.commitId = Objects.requireNonNull(commitId, "commitId");
            this.format = ArchiveFormat.ZIP;
            this.paths = ImmutableSet.builder();
        }

        @Nonnull
        public ArchiveRequest build() {
            return new ArchiveRequest(this);
        }

        @Nonnull
        public Builder format(@Nonnull ArchiveFormat value) {
            this.format = Objects.requireNonNull(value, "format");
            return this;
        }

        @Nonnull
        public Builder path(@Nullable String value) {
            Builder.addIf(NOT_BLANK, this.paths, value);
            return this;
        }

        @Nonnull
        public Builder paths(@Nullable Iterable<String> values) {
            Builder.addIf(NOT_BLANK, this.paths, values);
            return this;
        }

        @Nonnull
        public Builder paths(@Nullable String value, String ... values) {
            Builder.addIf(NOT_BLANK, this.paths, value, values);
            return this;
        }

        @Nonnull
        public Builder prefix(@Nullable String value) {
            this.prefix = StringUtils.trimToNull((String)value);
            return this;
        }
    }
}

