/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.content;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.BuilderSupport;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class ChangesRequest {
    private final Repository repository;
    private final String sinceId;
    private final String untilId;
    private final boolean withComments;

    private ChangesRequest(Builder builder) {
        this.repository = builder.repository;
        this.sinceId = builder.sinceId;
        this.untilId = builder.untilId;
        this.withComments = builder.withComments;
    }

    @Nonnull
    public Repository getRepository() {
        return this.repository;
    }

    @Nullable
    public String getSinceId() {
        return this.sinceId;
    }

    @Nonnull
    public String getUntilId() {
        return this.untilId;
    }

    public boolean isWithComments() {
        return this.withComments;
    }

    public static class Builder
    extends BuilderSupport {
        private final Repository repository;
        private final String untilId;
        private String sinceId;
        private boolean withComments;

        public Builder(@Nonnull ChangesRequest request) {
            this.repository = Objects.requireNonNull(Objects.requireNonNull(request, "request").getRepository(), "request.repository");
            this.sinceId = StringUtils.trimToNull((String)request.getSinceId());
            this.untilId = Builder.checkNotBlank(request.getUntilId(), "request.untilId");
            this.withComments = request.isWithComments();
        }

        public Builder(@Nonnull Repository repository, @Nonnull String untilId) {
            this.repository = Objects.requireNonNull(repository, "repository");
            this.untilId = Builder.checkNotBlank(untilId, "untilId");
            this.withComments = true;
        }

        @Nonnull
        public ChangesRequest build() {
            return new ChangesRequest(this);
        }

        @Nonnull
        public Builder sinceId(@Nullable String value) {
            this.sinceId = StringUtils.trimToNull((String)value);
            return this;
        }

        @Nonnull
        public Builder withComments(boolean value) {
            this.withComments = value;
            return this;
        }
    }
}

