/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.content;

import com.atlassian.bitbucket.content.DiffSegmentType;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public enum DiffFileType {
    FROM(0),
    TO(1);

    private final int id;

    private DiffFileType(int id) {
        this.id = id;
    }

    @Nonnull
    public static DiffFileType forSegmentType(@Nonnull DiffSegmentType segmentType) {
        Objects.requireNonNull(segmentType, "segmentType");
        if (segmentType == DiffSegmentType.REMOVED || segmentType == DiffSegmentType.CONTEXT) {
            return FROM;
        }
        if (segmentType == DiffSegmentType.ADDED) {
            return TO;
        }
        throw new IllegalArgumentException("Unrecognized segment type: " + String.valueOf((Object)segmentType));
    }

    @Nonnull
    public static DiffFileType fromId(int id) {
        for (DiffFileType value : DiffFileType.values()) {
            if (value.getId() != id) continue;
            return value;
        }
        throw new IllegalArgumentException("No DiffFileType is associated with ID [" + id + "]");
    }

    public int getId() {
        return this.id;
    }
}

