/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.content;

import com.atlassian.bitbucket.content.AbstractDiffRequest;
import com.atlassian.bitbucket.content.DiffWhitespace;
import com.atlassian.bitbucket.repository.Repository;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class DiffRequest
extends AbstractDiffRequest {
    private final boolean autoSrcPath;
    private final Repository repository;
    private final Repository secondaryRepository;
    private final String sinceId;
    private final String untilId;
    private final boolean withComments;

    private DiffRequest(Builder builder) {
        super(builder);
        this.autoSrcPath = builder.autoSrcPath;
        this.repository = builder.repository;
        this.secondaryRepository = builder.secondaryRepository;
        this.sinceId = builder.sinceId;
        this.untilId = builder.untilId;
        this.withComments = builder.withComments;
        if (this.autoSrcPath) {
            if (this.getPaths().isEmpty()) {
                throw new IllegalStateException("A path must be supplied when attempting to resolve the source path");
            }
            if (this.getPaths().size() > 1) {
                throw new IllegalStateException("Resolving the source path is only possible with a single path");
            }
        }
        if (this.secondaryRepository != null && ObjectUtils.notEqual((Object)this.repository.getHierarchyId(), (Object)this.secondaryRepository.getHierarchyId())) {
            throw new IllegalStateException(this.secondaryRepository.getProject().getKey() + "/" + this.secondaryRepository.getSlug() + " is not from the same hierarchy as " + this.repository.getProject().getKey() + "/" + this.repository.getSlug() + "; patch may only be streamed between repositories from the same hierarchy.");
        }
    }

    @Nonnull
    public Repository getRepository() {
        return this.repository;
    }

    @Nullable
    public Repository getSecondaryRepository() {
        return this.secondaryRepository;
    }

    @Nullable
    public String getSinceId() {
        return this.sinceId;
    }

    @Nonnull
    public String getUntilId() {
        return this.untilId;
    }

    public boolean isWithAutoSrcPath() {
        return this.autoSrcPath;
    }

    public boolean isWithComments() {
        return this.withComments;
    }

    public static class Builder
    extends AbstractDiffRequest.AbstractBuilder<Builder, DiffRequest> {
        private final Repository repository;
        private final String untilId;
        private boolean autoSrcPath;
        private Repository secondaryRepository;
        private String sinceId;
        private boolean withComments;

        public Builder(@Nonnull DiffRequest request) {
            super(request);
            this.autoSrcPath = request.isWithAutoSrcPath();
            this.repository = Objects.requireNonNull(request.getRepository(), "request.repository");
            this.sinceId = StringUtils.trimToNull((String)request.getSinceId());
            this.untilId = Objects.requireNonNull(request.getUntilId(), "request.untilId");
            this.withComments = request.isWithComments();
        }

        public Builder(@Nonnull Repository repository, @Nonnull String untilId) {
            Objects.requireNonNull(untilId, "untilId");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)untilId), (Object)"An \"until\" ID is required to stream a diff");
            this.repository = Objects.requireNonNull(repository, "repository");
            this.untilId = untilId;
            this.withComments = true;
        }

        @Nonnull
        public Builder autoSrcPath(boolean value) {
            this.autoSrcPath = value;
            return this.self();
        }

        @Override
        @Nonnull
        public DiffRequest build() {
            return new DiffRequest(this);
        }

        @Override
        @Nonnull
        public Builder contextLines(int value) {
            return (Builder)super.contextLines(value);
        }

        @Nonnull
        public Builder secondaryRepository(@Nullable Repository value) {
            this.secondaryRepository = value;
            return this;
        }

        @Nonnull
        public Builder sinceId(@Nullable String value) {
            this.sinceId = StringUtils.trimToNull((String)value);
            return this.self();
        }

        @Override
        @Nonnull
        public Builder path(@Nullable String value) {
            return (Builder)super.path(value);
        }

        @Override
        @Nonnull
        public Builder paths(@Nullable Iterable<String> values) {
            return (Builder)super.paths(values);
        }

        @Override
        @Nonnull
        public Builder paths(@Nullable String value, String ... values) {
            return (Builder)super.paths(value, values);
        }

        @Override
        @Nonnull
        public Builder whitespace(@Nonnull DiffWhitespace value) {
            return (Builder)super.whitespace(value);
        }

        @Nonnull
        public Builder withComments(boolean value) {
            this.withComments = value;
            return this.self();
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

