/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.content;

import com.atlassian.bitbucket.content.DiffWhitespace;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class DiffStatsSummaryRequest {
    private final boolean autoSrcPath;
    private final Set<String> paths;
    private final Repository repository;
    private final Repository secondaryRepository;
    private final String sinceId;
    private final String untilId;
    private final DiffWhitespace whitespace;

    private DiffStatsSummaryRequest(Builder builder) {
        this.autoSrcPath = builder.autoSrcPath;
        this.paths = builder.paths.build();
        this.repository = builder.repository;
        this.secondaryRepository = builder.secondaryRepository;
        this.sinceId = builder.sinceId;
        this.untilId = builder.untilId;
        this.whitespace = builder.whitespace;
        if (this.autoSrcPath) {
            if (this.paths.isEmpty()) {
                throw new IllegalStateException("A path must be supplied when attempting to resolve the source path");
            }
            if (this.paths.size() > 1) {
                throw new IllegalStateException("Resolving the source path is only possible with a single path");
            }
        }
        if (this.secondaryRepository != null && ObjectUtils.notEqual((Object)this.repository.getHierarchyId(), (Object)this.secondaryRepository.getHierarchyId())) {
            throw new IllegalStateException(this.secondaryRepository.getProject().getKey() + "/" + this.secondaryRepository.getSlug() + " is not from the same hierarchy as " + this.repository.getProject().getKey() + "/" + this.repository.getSlug() + "; patch may only be streamed between repositories from the same hierarchy.");
        }
    }

    @Nonnull
    public Set<String> getPaths() {
        return this.paths;
    }

    @Nonnull
    public Repository getRepository() {
        return this.repository;
    }

    @Nullable
    public Repository getSecondaryRepository() {
        return this.secondaryRepository;
    }

    @Nullable
    public String getSinceId() {
        return this.sinceId;
    }

    @Nonnull
    public String getUntilId() {
        return this.untilId;
    }

    @Nonnull
    public DiffWhitespace getWhitespace() {
        return this.whitespace;
    }

    public boolean isWithAutoSrcPath() {
        return this.autoSrcPath;
    }

    public static class Builder
    extends BuilderSupport {
        private final ImmutableSet.Builder<String> paths = ImmutableSet.builder();
        private final Repository repository;
        private final String untilId;
        private boolean autoSrcPath;
        private Repository secondaryRepository;
        private String sinceId;
        private DiffWhitespace whitespace;

        public Builder(@Nonnull Repository repository, @Nonnull String untilId) {
            Objects.requireNonNull(untilId, "untilId");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)untilId), (Object)"An \"until\" ID is required to generate diff stats summary");
            this.repository = Objects.requireNonNull(repository, "repository");
            this.untilId = untilId;
            this.whitespace = DiffWhitespace.SHOW;
        }

        @Nonnull
        public Builder autoSrcPath(boolean value) {
            this.autoSrcPath = value;
            return this;
        }

        @Nonnull
        public DiffStatsSummaryRequest build() {
            return new DiffStatsSummaryRequest(this);
        }

        @Nonnull
        public Builder path(@Nullable String value) {
            Builder.addIf(NOT_BLANK, this.paths, value);
            return this;
        }

        @Nonnull
        public Builder secondaryRepository(@Nullable Repository value) {
            this.secondaryRepository = value;
            return this;
        }

        @Nonnull
        public Builder sinceId(@Nullable String value) {
            this.sinceId = StringUtils.trimToNull((String)value);
            return this;
        }

        @Nonnull
        public Builder whitespace(@Nonnull DiffWhitespace value) {
            this.whitespace = Objects.requireNonNull(value, "whitespace");
            return this;
        }
    }
}

