/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.content;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.BuilderSupport;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class PatchRequest {
    private final boolean allAncestors;
    private final Repository repository;
    private final Repository secondaryRepository;
    private final String sinceId;
    private final String untilId;

    private PatchRequest(Builder builder) {
        this.allAncestors = builder.allAncestors;
        this.repository = builder.repository;
        this.secondaryRepository = builder.secondaryRepository;
        this.sinceId = builder.sinceId;
        this.untilId = builder.untilId;
        if (this.secondaryRepository != null && ObjectUtils.notEqual((Object)this.repository.getHierarchyId(), (Object)this.secondaryRepository.getHierarchyId())) {
            throw new IllegalStateException(this.secondaryRepository.getProject().getKey() + "/" + this.secondaryRepository.getSlug() + " is not from the same hierarchy as " + this.repository.getProject().getKey() + "/" + this.repository.getSlug() + "; patch may only be streamed between repositories from the same hierarchy.");
        }
    }

    @Nonnull
    public Repository getRepository() {
        return this.repository;
    }

    @Nullable
    public Repository getSecondaryRepository() {
        return this.secondaryRepository;
    }

    @Nullable
    public String getSinceId() {
        return this.sinceId;
    }

    @Nonnull
    public String getUntilId() {
        return this.untilId;
    }

    public boolean isAllAncestors() {
        return this.allAncestors;
    }

    public static class Builder
    extends BuilderSupport {
        private final Repository repository;
        private final String untilId;
        private boolean allAncestors;
        private Repository secondaryRepository;
        private String sinceId;

        public Builder(@Nonnull Repository repository, @Nonnull String untilId) {
            this.repository = Objects.requireNonNull(repository, "repository");
            this.untilId = Builder.requireNonBlank(untilId, "untilId");
        }

        @Nonnull
        public Builder allAncestors(boolean value) {
            this.allAncestors = value;
            return this;
        }

        @Nonnull
        public PatchRequest build() {
            return new PatchRequest(this);
        }

        @Nonnull
        public Builder secondaryRepository(@Nullable Repository value) {
            this.secondaryRepository = value;
            return this;
        }

        @Nonnull
        public Builder sinceId(@Nullable String value) {
            this.sinceId = StringUtils.trimToNull((String)value);
            return this;
        }
    }
}

