/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.content;

import com.atlassian.bitbucket.content.DiffStatsSummary;
import jakarta.annotation.Nonnull;

public class SimpleDiffStatsSummary
implements DiffStatsSummary {
    private final long filesChanged;
    private final long totalDeletions;
    private final long totalInsertions;

    private SimpleDiffStatsSummary(Builder builder) {
        this.filesChanged = builder.filesChanged;
        this.totalDeletions = builder.totalDeletions;
        this.totalInsertions = builder.totalInsertions;
    }

    @Override
    public long getFilesChanged() {
        return this.filesChanged;
    }

    @Override
    public long getTotalDeletions() {
        return this.totalDeletions;
    }

    @Override
    public long getTotalInsertions() {
        return this.totalInsertions;
    }

    public static class Builder {
        private long filesChanged;
        private long totalDeletions;
        private long totalInsertions;

        @Nonnull
        public DiffStatsSummary build() {
            return new SimpleDiffStatsSummary(this);
        }

        @Nonnull
        public Builder filesChanged(long filesChanged) {
            this.filesChanged = filesChanged;
            return this;
        }

        @Nonnull
        public Builder totalDeletions(long totalDeletions) {
            this.totalDeletions = totalDeletions;
            return this;
        }

        @Nonnull
        public Builder totalInsertions(long totalInsertions) {
            this.totalInsertions = totalInsertions;
            return this;
        }
    }
}

