/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.event.cluster;

import com.atlassian.bitbucket.cluster.ClusterNode;
import com.atlassian.bitbucket.event.cluster.ClusterMembershipEvent;
import com.atlassian.event.api.AsynchronousPreferred;
import jakarta.annotation.Nonnull;
import java.util.Set;

@AsynchronousPreferred
public class ClusterNodeAddedEvent
extends ClusterMembershipEvent {
    private final boolean maybeNetworkPartionResolved;

    public ClusterNodeAddedEvent(@Nonnull Object source, @Nonnull ClusterNode node, @Nonnull Set<ClusterNode> currentNodes) {
        super(source, node, currentNodes);
        this.maybeNetworkPartionResolved = node.isFullyStarted() && currentNodes.stream().filter(ClusterNode::isLocal).anyMatch(ClusterNode::isFullyStarted);
    }

    @Nonnull
    public ClusterNode getAddedNode() {
        return this.getNode();
    }

    public boolean isMaybeNetworkPartitionResolved() {
        return this.maybeNetworkPartionResolved;
    }
}

