/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.event.content;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bitbucket.event.branch.BranchChangedEvent;
import com.atlassian.bitbucket.io.InputSupplier;
import com.atlassian.bitbucket.repository.Branch;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.event.api.AsynchronousPreferred;
import jakarta.annotation.Nonnull;
import java.io.InputStream;
import java.util.Objects;

@AsynchronousPreferred
@EventName(value="stash.content.file.edited")
public class FileEditedEvent
extends BranchChangedEvent {
    private final InputSupplier<InputStream> content;
    private final String message;
    private final String path;

    public FileEditedEvent(@Nonnull Object source, @Nonnull Repository repository, @Nonnull Branch branch, @Nonnull RefChange refChange, @Nonnull String path, @Nonnull InputSupplier<InputStream> content, @Nonnull String message) {
        super(source, repository, branch, refChange);
        this.path = Objects.requireNonNull(path, "path");
        this.content = Objects.requireNonNull(content, "content");
        this.message = Objects.requireNonNull(message, "message");
    }

    @Nonnull
    public InputSupplier<InputStream> getContent() {
        return this.content;
    }

    @Nonnull
    public String getMessage() {
        return this.message;
    }

    @Nonnull
    public String getPath() {
        return this.path;
    }
}

