/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.event.mirror;

import com.atlassian.bitbucket.event.mirror.AbstractRepositoryMirrorEvent;
import com.atlassian.bitbucket.repository.MinimalRef;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.scm.mirror.RepositorySynchronizationType;
import com.atlassian.bitbucket.util.NamedLink;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.Objects;

public class RepositoryMirrorSynchronizedEvent
extends AbstractRepositoryMirrorEvent {
    private final Collection<NamedLink> cloneLinks;
    private final Collection<MinimalRef> failedRefs;
    private final Collection<RefChange> refChanges;
    private final boolean refLimitExceeded;
    private final RepositorySynchronizationType syncType;

    private RepositoryMirrorSynchronizedEvent(Builder builder) {
        super(builder);
        this.cloneLinks = builder.cloneLinks;
        this.failedRefs = builder.failedRefs;
        this.refChanges = builder.refChanges;
        this.refLimitExceeded = builder.refLimitExceeded;
        this.syncType = builder.syncType;
    }

    @Nonnull
    public Collection<NamedLink> getCloneLinks() {
        return this.cloneLinks;
    }

    @Nonnull
    public Collection<MinimalRef> getFailedRefs() {
        return this.failedRefs;
    }

    @Nonnull
    public Collection<RefChange> getRefChanges() {
        return this.refChanges;
    }

    @Nullable
    public RepositorySynchronizationType getSyncType() {
        return this.syncType;
    }

    public boolean isRefLimitExceeded() {
        return this.refLimitExceeded;
    }

    public static class Builder
    extends AbstractRepositoryMirrorEvent.Builder<Builder, RepositoryMirrorSynchronizedEvent> {
        private Collection<NamedLink> cloneLinks;
        private Collection<MinimalRef> failedRefs;
        private Collection<RefChange> refChanges;
        private boolean refLimitExceeded;
        private RepositorySynchronizationType syncType;

        @Override
        @Nonnull
        public RepositoryMirrorSynchronizedEvent build() {
            this.validate();
            return new RepositoryMirrorSynchronizedEvent(this);
        }

        @Nonnull
        public Builder cloneLinks(@Nonnull Collection<NamedLink> value) {
            this.cloneLinks = Objects.requireNonNull(value, "cloneLinks");
            return this;
        }

        @Nonnull
        public Builder failedRefs(@Nonnull Collection<MinimalRef> value) {
            this.failedRefs = Objects.requireNonNull(value, "failedRefs");
            return this;
        }

        @Nonnull
        public Builder refChanges(@Nonnull Collection<RefChange> value) {
            this.refChanges = Objects.requireNonNull(value, "refChanges");
            return this;
        }

        @Nonnull
        public Builder refLimitExceeded(boolean value) {
            this.refLimitExceeded = value;
            return this;
        }

        @Nonnull
        public Builder syncType(RepositorySynchronizationType value) {
            this.syncType = value;
            return this;
        }

        @Override
        protected void validate() {
            super.validate();
            if (this.cloneLinks == null) {
                throw new IllegalArgumentException("cloneLinks is required");
            }
            if (this.failedRefs == null) {
                throw new IllegalStateException("failedRefs is required");
            }
            if (this.refChanges == null) {
                throw new IllegalStateException("refChanges is required");
            }
            if (this.refLimitExceeded && !this.refChanges.isEmpty()) {
                throw new IllegalStateException("When ref limit is exceeded the list of ref changes should be empty");
            }
        }
    }
}

