/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.event.permission;

import com.atlassian.bitbucket.event.annotation.TransactionAware;
import com.atlassian.bitbucket.event.permission.GlobalPermissionEvent;
import com.atlassian.bitbucket.event.permission.PermissionRevocationRequestedEvent;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.CancelState;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;

@TransactionAware(value=TransactionAware.When.IMMEDIATE)
public class GlobalPermissionRevocationRequestedEvent
extends GlobalPermissionEvent
implements PermissionRevocationRequestedEvent {
    private final CancelState cancelState;

    public GlobalPermissionRevocationRequestedEvent(@Nonnull Object source, @Nonnull Permission permission, @Nullable String affectedGroup, @Nullable ApplicationUser affectedUser, @Nonnull CancelState cancelState) {
        super(source, permission, affectedGroup, affectedUser);
        this.cancelState = Objects.requireNonNull(cancelState, "cancelState");
    }

    @Override
    public void cancel(@Nonnull KeyedMessage message) {
        this.cancelState.cancel(message);
    }

    @Override
    public boolean isCanceled() {
        return this.cancelState.isCanceled();
    }
}

