/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.event.permission;

import com.atlassian.bitbucket.event.annotation.TransactionAware;
import com.atlassian.bitbucket.event.permission.PermissionGrantRequestedEvent;
import com.atlassian.bitbucket.event.permission.RepositoryPermissionEvent;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.CancelState;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;

@TransactionAware(value=TransactionAware.When.IMMEDIATE)
public class RepositoryPermissionGrantRequestedEvent
extends RepositoryPermissionEvent
implements PermissionGrantRequestedEvent {
    private final CancelState cancelState;

    public RepositoryPermissionGrantRequestedEvent(@Nonnull Object source, @Nonnull Permission permission, @Nonnull Repository repository, @Nullable String affectedGroup, @Nullable ApplicationUser affectedUser, @Nonnull CancelState cancelState) {
        super(source, permission, repository, affectedGroup, affectedUser);
        this.cancelState = Objects.requireNonNull(cancelState, "cancelState");
    }

    @Override
    public void cancel(@Nonnull KeyedMessage message) {
        this.cancelState.cancel(message);
    }

    @Override
    public boolean isCanceled() {
        return this.cancelState.isCanceled();
    }
}

