/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.event.pull;

import com.atlassian.bitbucket.comment.Comment;
import com.atlassian.bitbucket.comment.CommentAction;
import com.atlassian.bitbucket.event.CancelableEvent;
import com.atlassian.bitbucket.event.annotation.TransactionAware;
import com.atlassian.bitbucket.event.pull.PullRequestEvent;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestAction;
import com.atlassian.bitbucket.util.CancelState;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;

@TransactionAware(value=TransactionAware.When.IMMEDIATE)
public abstract class PullRequestCancelableCommentEvent
extends PullRequestEvent
implements CancelableEvent {
    private final CancelState cancelState;
    private final Comment comment;
    private final CommentAction commentAction;
    private final Comment parent;

    protected PullRequestCancelableCommentEvent(@Nonnull Object source, @Nonnull PullRequest pullRequest, @Nonnull Comment comment, @Nullable Comment parent, @Nonnull CommentAction commentAction, @Nonnull CancelState cancelState) {
        super(source, pullRequest, PullRequestAction.COMMENTED);
        this.cancelState = Objects.requireNonNull(cancelState, "cancelState");
        this.comment = Objects.requireNonNull(comment, "comment");
        this.commentAction = Objects.requireNonNull(commentAction, "commentAction");
        this.parent = parent;
    }

    @Override
    public void cancel(@Nonnull KeyedMessage message) {
        this.cancelState.cancel(message);
    }

    @Nonnull
    public Comment getComment() {
        return this.comment;
    }

    @Nonnull
    public CommentAction getCommentAction() {
        return this.commentAction;
    }

    @Nullable
    public Comment getParent() {
        return this.parent;
    }

    @Override
    public boolean isCanceled() {
        return this.cancelState.isCanceled();
    }
}

