/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.event.pull;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bitbucket.event.pull.PullRequestEvent;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestAction;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.event.api.AsynchronousPreferred;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import java.util.Set;

@AsynchronousPreferred
@EventName(value="stash.pullrequest.participants.updated")
public class PullRequestParticipantsUpdatedEvent
extends PullRequestEvent {
    private final Set<ApplicationUser> addedParticipants;
    private final Set<ApplicationUser> removedParticipants;

    public PullRequestParticipantsUpdatedEvent(@Nonnull Object source, @Nonnull PullRequest pullRequest, @Nonnull Set<ApplicationUser> added, @Nonnull Set<ApplicationUser> removed) {
        super(source, pullRequest, PullRequestAction.UPDATED);
        this.addedParticipants = ImmutableSet.copyOf(added);
        this.removedParticipants = ImmutableSet.copyOf(removed);
    }

    @Nonnull
    public Set<ApplicationUser> getAddedParticipants() {
        return this.addedParticipants;
    }

    @Nonnull
    public Set<ApplicationUser> getRemovedParticipants() {
        return this.removedParticipants;
    }
}

