/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.event.pull;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bitbucket.event.pull.PullRequestEvent;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestAction;
import com.atlassian.event.api.AsynchronousPreferred;
import jakarta.annotation.Nonnull;
import java.util.Objects;

@AsynchronousPreferred
@EventName(value="stash.pullrequest.reopened")
public class PullRequestReopenedEvent
extends PullRequestEvent {
    private final String previousFromHash;
    private final String previousToHash;

    public PullRequestReopenedEvent(@Nonnull Object source, @Nonnull PullRequest pullRequest, @Nonnull String previousFromHash, @Nonnull String previousToHash) {
        super(source, pullRequest, PullRequestAction.REOPENED);
        this.previousFromHash = Objects.requireNonNull(previousFromHash, "previousFromHash");
        this.previousToHash = Objects.requireNonNull(previousToHash, "previousToHash");
    }

    @Nonnull
    public String getPreviousFromHash() {
        return this.previousFromHash;
    }

    @Nonnull
    public String getPreviousToHash() {
        return this.previousToHash;
    }
}

