/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.event.pull;

import com.atlassian.bitbucket.event.pull.PullRequestEvent;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestAction;
import com.atlassian.bitbucket.repository.Ref;
import com.atlassian.event.api.AsynchronousPreferred;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;

@AsynchronousPreferred
public class PullRequestUpdatedEvent
extends PullRequestEvent {
    private final String previousDescription;
    private final boolean previousDraft;
    private final String previousTitle;
    private final Ref previousToBranch;

    public PullRequestUpdatedEvent(@Nonnull Object source, @Nonnull PullRequest pullRequest, @Nonnull String previousTitle, @Nullable String previousDescription, @Nullable Ref previousToBranch, boolean previousDraft) {
        super(source, pullRequest, PullRequestAction.UPDATED);
        this.previousDescription = previousDescription;
        this.previousDraft = previousDraft;
        this.previousTitle = Objects.requireNonNull(previousTitle, "previousTitle");
        this.previousToBranch = previousToBranch;
    }

    @Nullable
    public String getPreviousDescription() {
        return this.previousDescription;
    }

    @Nonnull
    public String getPreviousTitle() {
        return this.previousTitle;
    }

    @Nullable
    public Ref getPreviousToBranch() {
        return this.previousToBranch;
    }

    public boolean isPreviousDraft() {
        return this.previousDraft;
    }
}

