/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.event.repository;

import com.atlassian.bitbucket.event.repository.RepositoryEvent;
import com.atlassian.bitbucket.repository.Repository;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;

public class AbstractRepositoryModificationEvent
extends RepositoryEvent {
    protected final Repository newValue;
    protected final Repository oldValue;

    public AbstractRepositoryModificationEvent(@Nonnull Object source, @Nonnull Repository repository, @Nonnull Repository oldValue, @Nonnull Repository newValue) {
        super(source, repository);
        this.newValue = Objects.requireNonNull(newValue, "newValue");
        this.oldValue = Objects.requireNonNull(oldValue, "oldValue");
    }

    @Nonnull
    public Repository getNewValue() {
        return this.newValue;
    }

    @Nonnull
    public Repository getOldValue() {
        return this.oldValue;
    }

    public boolean isNameChanged() {
        return ObjectUtils.notEqual((Object)this.getOldValue().getName(), (Object)this.getNewValue().getName());
    }

    public boolean isOriginChanged() {
        return ObjectUtils.notEqual((Object)this.getOldValue().getOrigin(), (Object)this.getNewValue().getOrigin());
    }

    public boolean isMoved() {
        return this.getOldValue().getProject().getId() != this.getNewValue().getProject().getId();
    }

    public boolean isSlugChanged() {
        return ObjectUtils.notEqual((Object)this.getOldValue().getSlug(), (Object)this.getNewValue().getSlug());
    }

    public boolean isStateChanged() {
        return ObjectUtils.notEqual((Object)((Object)this.getOldValue().getState()), (Object)((Object)this.getNewValue().getState()));
    }
}

