/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.event.repository;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bitbucket.event.repository.RepositoryEvent;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.event.api.AsynchronousPreferred;
import jakarta.annotation.Nonnull;
import java.util.Objects;

@AsynchronousPreferred
@EventName(value="stash.repository.delete.blocked")
public class RepositoryDeleteBlockedEvent
extends RepositoryEvent {
    private final boolean isPersonalRepo;
    private final boolean isPublicRepo;
    private final Permission userRole;

    public RepositoryDeleteBlockedEvent(@Nonnull Object source, @Nonnull Repository repository, @Nonnull Permission userRole, boolean isPersonalRepo, boolean isPublicRepo) {
        super(source, repository);
        this.isPersonalRepo = isPersonalRepo;
        this.isPublicRepo = isPublicRepo;
        this.userRole = Objects.requireNonNull(userRole, "userRole");
    }

    public boolean getIsPersonalRepo() {
        return this.isPersonalRepo;
    }

    public boolean getIsPublicRepo() {
        return this.isPublicRepo;
    }

    @Nonnull
    public Permission getUserRole() {
        return this.userRole;
    }
}

