/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.filestore;

import com.atlassian.bitbucket.filestore.FilePath;
import com.atlassian.bitbucket.util.BuilderSupport;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.Duration;
import java.util.Objects;

public class GenerateGetUrlRequest {
    private final Duration expiry;
    private final String namespace;
    private final FilePath path;
    private final String responseContentDisposition;
    private final String responseContentType;

    private GenerateGetUrlRequest(@Nonnull Builder builder) {
        this.expiry = builder.expiry;
        this.namespace = builder.namespace;
        this.path = builder.path;
        this.responseContentDisposition = builder.responseContentDisposition;
        this.responseContentType = builder.responseContentType;
    }

    @Nullable
    public Duration getExpiry() {
        return this.expiry;
    }

    @Nullable
    public String getNamespace() {
        return this.namespace;
    }

    @Nullable
    public FilePath getPath() {
        return this.path;
    }

    @Nullable
    public String getResponseContentDisposition() {
        return this.responseContentDisposition;
    }

    @Nullable
    public String getResponseContentType() {
        return this.responseContentType;
    }

    public static class Builder
    extends BuilderSupport {
        private Duration expiry;
        private String namespace;
        private FilePath path;
        private String responseContentDisposition;
        private String responseContentType;

        @Nonnull
        public GenerateGetUrlRequest build() {
            return new GenerateGetUrlRequest(this);
        }

        @Nonnull
        public Builder expiry(@Nullable Duration value) {
            this.expiry = value;
            return this;
        }

        @Nonnull
        public Builder namespace(@Nonnull String value) {
            this.namespace = Builder.requireNonBlank(value, "namespace");
            return this;
        }

        @Nonnull
        public Builder path(@Nonnull FilePath value) {
            this.path = Objects.requireNonNull(value, "value");
            return this;
        }

        @Nonnull
        public Builder responseContentDisposition(@Nullable String value) {
            this.responseContentDisposition = value;
            return this;
        }

        @Nonnull
        public Builder responseContentType(@Nullable String value) {
            this.responseContentType = value;
            return this;
        }
    }
}

