/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.hook.repository;

import com.atlassian.bitbucket.hook.ScmHookDetails;
import com.atlassian.bitbucket.hook.repository.AbstractRepositoryHookRequest;
import com.atlassian.bitbucket.hook.repository.RepositoryHookTrigger;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.Repository;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;

public class SimpleRepositoryHookRequest
extends AbstractRepositoryHookRequest {
    private final Collection<RefChange> refChanges;
    private final ScmHookDetails scmHookDetails;

    protected SimpleRepositoryHookRequest(AbstractBuilder<?> builder) {
        super(builder);
        this.refChanges = builder.refChanges.build();
        this.scmHookDetails = builder.scmHookDetails;
    }

    @Override
    @Nonnull
    public Collection<RefChange> getRefChanges() {
        return this.refChanges;
    }

    @Override
    @Nonnull
    public Optional<ScmHookDetails> getScmHookDetails() {
        return Optional.ofNullable(this.scmHookDetails);
    }

    protected static abstract class AbstractBuilder<B extends AbstractBuilder<B>>
    extends AbstractRepositoryHookRequest.AbstractBuilder<B> {
        private final ImmutableSet.Builder<RefChange> refChanges = ImmutableSet.builder();
        private ScmHookDetails scmHookDetails;

        protected AbstractBuilder(@Nonnull Repository repository, @Nonnull RepositoryHookTrigger trigger) {
            super(repository, trigger);
        }

        @Nonnull
        public B refChanges(@Nullable RefChange value, RefChange ... moreValues) {
            AbstractBuilder.addIf(Objects::nonNull, this.refChanges, value, moreValues);
            return (B)this.self();
        }

        @Nonnull
        public B refChanges(@Nullable Iterable<RefChange> values) {
            AbstractBuilder.addIf(Objects::nonNull, this.refChanges, values);
            return (B)this.self();
        }

        @Nonnull
        public B scmHookDetails(@Nullable ScmHookDetails value) {
            this.scmHookDetails = value;
            return (B)this.self();
        }

        @Override
        @Nonnull
        protected abstract B self();
    }

    public static class Builder
    extends AbstractBuilder<Builder> {
        public Builder(@Nonnull Repository repository, @Nonnull RepositoryHookTrigger trigger) {
            super(repository, trigger);
        }

        @Nonnull
        public SimpleRepositoryHookRequest build() {
            return new SimpleRepositoryHookRequest(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

