/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.hook.script;

import com.atlassian.bitbucket.hook.script.HookScriptType;
import com.atlassian.bitbucket.io.InputSupplier;
import com.atlassian.bitbucket.util.BuilderSupport;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class HookScriptCreateRequest {
    private final InputSupplier<InputStream> content;
    private final String description;
    private final String name;
    private final String pluginKey;
    private final HookScriptType type;

    private HookScriptCreateRequest(Builder builder) {
        this.content = builder.content;
        this.description = builder.description;
        this.name = builder.name;
        this.pluginKey = builder.pluginKey;
        this.type = builder.type;
    }

    @Nonnull
    public InputSupplier<InputStream> getContent() {
        return this.content;
    }

    @Nonnull
    public Optional<String> getDescription() {
        return Optional.ofNullable(this.description);
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public String getPluginKey() {
        return this.pluginKey;
    }

    @Nonnull
    public HookScriptType getType() {
        return this.type;
    }

    public static class Builder
    extends BuilderSupport {
        private final String name;
        private final String pluginKey;
        private final HookScriptType type;
        private InputSupplier<InputStream> content;
        private String description;

        public Builder(@Nonnull String name, @Nonnull String pluginKey, @Nonnull HookScriptType type) {
            this.name = Builder.requireNonBlank(name, "name");
            this.pluginKey = Builder.requireNonBlank(pluginKey, "pluginKey");
            this.type = Objects.requireNonNull(type, "type");
        }

        @Nonnull
        public HookScriptCreateRequest build() {
            if (this.content == null) {
                throw new IllegalStateException("Contents must be provided when creating a new hook script");
            }
            return new HookScriptCreateRequest(this);
        }

        @Nonnull
        public Builder content(@Nonnull InputSupplier<InputStream> value) {
            this.content = Objects.requireNonNull(value, "content");
            return this;
        }

        @Nonnull
        public Builder content(@Nonnull String value) {
            return this.content(Builder.requireNonBlank(value, "content").getBytes(StandardCharsets.UTF_8));
        }

        @Nonnull
        public Builder content(@Nonnull byte[] value) {
            if (Objects.requireNonNull(value, "content").length == 0) {
                throw new IllegalArgumentException("Hook script contents cannot be empty");
            }
            this.content = () -> new ByteArrayInputStream(value);
            return this;
        }

        @Nonnull
        public Builder description(@Nullable String value) {
            this.description = StringUtils.trimToNull((String)value);
            return this;
        }
    }
}

