/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.job;

import com.atlassian.bitbucket.job.Job;
import com.atlassian.bitbucket.job.JobMessageSeverity;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class JobMessageSearchRequest {
    private final Job job;
    private final Set<JobMessageSeverity> severities;
    private final String subject;

    private JobMessageSearchRequest(Builder builder) {
        this.job = builder.job;
        this.severities = ImmutableSet.copyOf(builder.severities);
        this.subject = builder.subject;
    }

    @Nonnull
    public Optional<Job> getJob() {
        return Optional.ofNullable(this.job);
    }

    @Nonnull
    public Set<JobMessageSeverity> getSeverities() {
        return this.severities;
    }

    @Nonnull
    public Optional<String> getSubject() {
        return Optional.ofNullable(this.subject);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobMessageSearchRequest that = (JobMessageSearchRequest)o;
        return com.google.common.base.Objects.equal(this.getJob().map(Job::getId), that.getJob().map(Job::getId)) && com.google.common.base.Objects.equal(this.getSeverities(), that.getSeverities()) && com.google.common.base.Objects.equal(this.getSubject(), that.getSubject());
    }

    public int hashCode() {
        return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.getJob(), this.getSeverities(), this.getSubject()});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("job.id", this.job.getId()).add("severities", this.severities).add("subject", (Object)this.subject).toString();
    }

    public static class Builder
    extends BuilderSupport {
        private Job job;
        private EnumSet<JobMessageSeverity> severities = EnumSet.noneOf(JobMessageSeverity.class);
        private String subject;

        @Nonnull
        public JobMessageSearchRequest build() {
            return new JobMessageSearchRequest(this);
        }

        @Nonnull
        public Builder job(@Nullable Job value) {
            this.job = value;
            return this;
        }

        @Nonnull
        public Builder severity(@Nullable JobMessageSeverity value) {
            Builder.addIf(Objects::nonNull, this.severities, value);
            return this;
        }

        @Nonnull
        public Builder severities(@Nonnull Iterable<JobMessageSeverity> values) {
            Builder.addIf(Objects::nonNull, this.severities, values);
            return this;
        }

        @Nonnull
        public Builder subject(@Nullable String value) {
            this.subject = value;
            return this;
        }
    }
}

