/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.job;

import com.atlassian.bitbucket.job.Job;
import com.atlassian.bitbucket.job.JobState;
import com.google.common.base.MoreObjects;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import org.apache.commons.lang3.StringUtils;

public class JobUpdateRequest {
    private final Job job;
    private final Integer progressPercentage;
    private final String progressMessage;
    private final JobState state;

    private JobUpdateRequest(Builder builder) {
        this.job = builder.job;
        this.progressPercentage = builder.progressPercentage;
        this.progressMessage = builder.progressMessage;
        this.state = builder.state;
    }

    @Nonnull
    public Job getJob() {
        return this.job;
    }

    @Nonnull
    public OptionalInt getProgressPercentage() {
        return this.progressPercentage == null ? OptionalInt.empty() : OptionalInt.of(this.progressPercentage);
    }

    @Nonnull
    public Optional<String> getProgressMessage() {
        return Optional.ofNullable(this.progressMessage);
    }

    @Nonnull
    public Optional<JobState> getState() {
        return Optional.ofNullable(this.state);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobUpdateRequest that = (JobUpdateRequest)o;
        return com.google.common.base.Objects.equal((Object)this.getJob().getId(), (Object)that.getJob().getId()) && com.google.common.base.Objects.equal((Object)this.getProgressPercentage(), (Object)that.getProgressPercentage()) && com.google.common.base.Objects.equal(this.getProgressMessage(), that.getProgressMessage()) && com.google.common.base.Objects.equal(this.getState(), that.getState());
    }

    public int hashCode() {
        return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.getJob(), this.getProgressPercentage(), this.getProgressMessage(), this.getState()});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("job.id", this.job.getId()).add("progressPercentage", (Object)this.progressPercentage).add("progressMessage", (Object)this.progressMessage).add("state", (Object)this.state).toString();
    }

    public static class Builder {
        private final Job job;
        private String progressMessage;
        private Integer progressPercentage;
        private JobState state;

        public Builder(@Nonnull Job job) {
            this.job = Objects.requireNonNull(job, "job");
        }

        @Nonnull
        public JobUpdateRequest build() {
            return new JobUpdateRequest(this);
        }

        @Nonnull
        public Builder progressMessage(@Nullable String value) {
            this.progressMessage = StringUtils.trimToNull((String)value);
            return this;
        }

        @Nonnull
        public Builder progressPercentage(int value) {
            this.progressPercentage = Math.max(0, Math.min(value, 100));
            return this;
        }

        @Nonnull
        public Builder state(@Nullable JobState value) {
            this.state = value;
            return this;
        }
    }
}

