/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.label;

import com.atlassian.bitbucket.label.Label;
import com.atlassian.bitbucket.label.LabelableType;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.Optional;

public class LabelableSearchRequest {
    private final Label label;
    private final LabelableType type;

    private LabelableSearchRequest(Builder builder) {
        this.label = builder.label;
        this.type = builder.type;
    }

    @Nonnull
    public Label getLabel() {
        return this.label;
    }

    @Nonnull
    public Optional<LabelableType> getType() {
        return Optional.ofNullable(this.type);
    }

    public static class Builder {
        private final Label label;
        private LabelableType type;

        public Builder(@Nonnull Label value) {
            this.label = Objects.requireNonNull(value, "label");
        }

        @Nonnull
        public LabelableSearchRequest build() {
            return new LabelableSearchRequest(this);
        }

        @Nonnull
        public Builder type(@Nullable LabelableType value) {
            this.type = value;
            return this;
        }
    }
}

