/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.mail;

import com.atlassian.bitbucket.mail.MailAttachment;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import jakarta.activation.DataSource;
import jakarta.activation.FileDataSource;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.File;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class MailMessage {
    private final String from;
    private final Map<String, String> headers;
    private final Set<String> to;
    private final Set<String> cc;
    private final Set<String> bcc;
    private final String text;
    private final String subject;
    private final Set<MailAttachment> attachments;

    public MailMessage(@Nonnull Set<String> to, @Nullable String from, @Nullable Set<String> cc, @Nullable Set<String> bcc, @Nullable Set<MailAttachment> attachments, @Nullable String text, @Nullable String subject, @Nullable Map<String, String> headers) {
        Preconditions.checkArgument((!to.isEmpty() ? 1 : 0) != 0, (Object)"One or more \"to\" addresses are required");
        this.from = StringUtils.trimToNull((String)from);
        this.headers = headers == null ? Collections.emptyMap() : ImmutableMap.copyOf(headers);
        this.to = ImmutableSet.copyOf(to);
        this.cc = cc != null ? ImmutableSet.copyOf(cc) : Collections.emptySet();
        this.bcc = bcc != null ? ImmutableSet.copyOf(bcc) : Collections.emptySet();
        this.attachments = attachments != null ? ImmutableSet.copyOf(attachments) : Collections.emptySet();
        this.text = StringUtils.defaultString((String)text);
        this.subject = StringUtils.defaultString((String)subject);
    }

    @Nullable
    public String getFrom() {
        return this.from;
    }

    @Nonnull
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Nonnull
    public Set<String> getTo() {
        return this.to;
    }

    @Nonnull
    public Set<String> getCc() {
        return this.cc;
    }

    @Nonnull
    public Set<String> getBcc() {
        return this.bcc;
    }

    @Nonnull
    public Set<MailAttachment> getAttachments() {
        return this.attachments;
    }

    @Nonnull
    public String getText() {
        return this.text;
    }

    @Nonnull
    public String getSubject() {
        return this.subject;
    }

    public boolean hasBcc() {
        return !this.bcc.isEmpty();
    }

    public boolean hasCc() {
        return !this.cc.isEmpty();
    }

    public boolean hasFrom() {
        return this.from != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MailMessage that = (MailMessage)o;
        return this.to.equals(that.to) && this.cc.equals(that.cc) && this.bcc.equals(that.bcc) && this.text.equals(that.text) && this.subject.equals(that.subject) && this.attachments.equals(that.attachments) && this.headers.equals(that.headers) && (this.from == null ? that.from == null : this.from.equals(that.from));
    }

    public int hashCode() {
        int result = this.to.hashCode();
        result = 31 * result + this.cc.hashCode();
        result = 31 * result + this.bcc.hashCode();
        result = 31 * result + this.text.hashCode();
        result = 31 * result + this.subject.hashCode();
        result = 31 * result + this.attachments.hashCode();
        result = 31 * result + this.headers.hashCode();
        if (this.from != null) {
            result = 31 * result + this.from.hashCode();
        }
        return result;
    }

    public static class Builder {
        private final Set<MailAttachment> attachments = new LinkedHashSet<MailAttachment>();
        private final Set<String> bcc = new LinkedHashSet<String>();
        private final Set<String> cc = new LinkedHashSet<String>();
        private final Map<String, String> headers = new LinkedHashMap<String, String>();
        private final Set<String> to = new LinkedHashSet<String>();
        private String from;
        private String subject;
        private String text;

        private void addRecipients(@Nonnull Set<String> target, String[] recipients) {
            if (recipients != null) {
                for (String recipient : recipients) {
                    if (recipient == null) continue;
                    target.add(recipient);
                }
            }
        }

        private void addRecipients(@Nonnull Set<String> target, Iterable<String> recipients) {
            if (recipients != null) {
                for (String recipient : recipients) {
                    if (recipient == null) continue;
                    target.add(recipient);
                }
            }
        }

        @Nonnull
        public Builder from(String value) {
            this.from = value;
            return this;
        }

        @Nonnull
        public Builder to(String ... recipients) {
            this.addRecipients(this.to, recipients);
            return this;
        }

        @Nonnull
        public Builder to(Iterable<String> recipients) {
            this.addRecipients(this.to, recipients);
            return this;
        }

        @Nonnull
        public Builder cc(String ... recipients) {
            this.addRecipients(this.cc, recipients);
            return this;
        }

        @Nonnull
        public Builder cc(Iterable<String> recipients) {
            this.addRecipients(this.cc, recipients);
            return this;
        }

        @Nonnull
        public Builder bcc(String ... recipients) {
            this.addRecipients(this.bcc, recipients);
            return this;
        }

        @Nonnull
        public Builder bcc(Iterable<String> recipients) {
            this.addRecipients(this.bcc, recipients);
            return this;
        }

        @Nonnull
        public Builder subject(String subject) {
            this.subject = subject;
            return this;
        }

        @Nonnull
        public Builder text(String text) {
            this.text = text;
            return this;
        }

        @Nonnull
        public Builder attachment(String fileName, DataSource source) {
            this.attachments.add(new MailAttachment(fileName, source));
            return this;
        }

        @Nonnull
        public Builder attachment(String fileName, File file) {
            return this.attachment(fileName, (DataSource)new FileDataSource(file));
        }

        @Nonnull
        public Builder attachment(String fileName, String pathToFile) {
            return this.attachment(fileName, new File(pathToFile));
        }

        @Nonnull
        public Builder header(String key, String value) {
            this.headers.put(key, value);
            return this;
        }

        @Nonnull
        public MailMessage build() {
            return new MailMessage(this.to, this.from, this.cc, this.bcc, this.attachments, this.text, this.subject, this.headers);
        }
    }
}

