/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.mail;

import com.atlassian.bitbucket.i18n.I18nKey;
import com.atlassian.bitbucket.mail.MailMessage;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public class SoyMailMessageRequest {
    private final String cssModuleKey;
    private final Map<String, Object> context;
    private final Iterable<ApplicationUser> recipients;
    private final I18nKey subjectKey;
    private final String soyTemplateModuleKey;
    private final String soyTemplateName;
    private final Function<MailMessage.Builder, MailMessage.Builder> messageEffector;

    private SoyMailMessageRequest(Builder builder) {
        this.recipients = builder.recipients.build();
        this.subjectKey = builder.subjectKey;
        this.soyTemplateModuleKey = builder.soyTemplateModuleKey;
        this.soyTemplateName = builder.soyTemplateName;
        this.cssModuleKey = builder.cssModuleKey;
        this.context = builder.context;
        this.messageEffector = builder.messageEffector;
    }

    @Nonnull
    public Map<String, Object> getContext() {
        return this.context;
    }

    @Nonnull
    public String getCssModuleKey() {
        return this.cssModuleKey;
    }

    @Nonnull
    public Iterable<ApplicationUser> getRecipients() {
        return this.recipients;
    }

    @Nonnull
    public String getSoyTemplateModuleKey() {
        return this.soyTemplateModuleKey;
    }

    @Nonnull
    public String getSoyTemplateName() {
        return this.soyTemplateName;
    }

    @Nullable
    public I18nKey getSubjectKey() {
        return this.subjectKey;
    }

    @Nonnull
    public Function<MailMessage.Builder, MailMessage.Builder> getMessageEffector() {
        return (Function)MoreObjects.firstNonNull(this.messageEffector, m -> m);
    }

    public static class Builder {
        private final ImmutableList.Builder<ApplicationUser> recipients = ImmutableList.builder();
        private String cssModuleKey;
        private Map<String, Object> context;
        private Function<MailMessage.Builder, MailMessage.Builder> messageEffector;
        private I18nKey subjectKey;
        private String soyTemplateModuleKey;
        private String soyTemplateName;

        @Nonnull
        public SoyMailMessageRequest build() {
            return new SoyMailMessageRequest(this);
        }

        @Nonnull
        public Builder cssModuleKey(@Nonnull String value) {
            this.cssModuleKey = Objects.requireNonNull(value, "cssModuleKey");
            return this;
        }

        @Nonnull
        public Builder context(@Nonnull Map<String, Object> value) {
            this.context = Objects.requireNonNull(value, "context");
            return this;
        }

        @Nonnull
        public Builder messageEffector(@Nullable Function<MailMessage.Builder, MailMessage.Builder> value) {
            this.messageEffector = value;
            return this;
        }

        @Nonnull
        public Builder recipients(@Nonnull Iterable<ApplicationUser> value) {
            this.recipients.addAll(Objects.requireNonNull(value, "recipients"));
            return this;
        }

        @Nonnull
        public Builder soyTemplateModuleKey(@Nonnull String value) {
            this.soyTemplateModuleKey = Objects.requireNonNull(value, "soyTemplateModuleKey");
            return this;
        }

        @Nonnull
        public Builder soyTemplateName(@Nonnull String value) {
            this.soyTemplateName = Objects.requireNonNull(value, "soyTemplateName");
            return this;
        }

        @Nonnull
        public Builder subjectKey(@Nonnull I18nKey value) {
            this.subjectKey = Objects.requireNonNull(value, "subjectKey");
            return this;
        }
    }
}

