/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.markup;

import com.atlassian.bitbucket.markup.UrlMode;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class RenderContext {
    private final Boolean includeHeadingId;
    private final Boolean hardwrap;
    private final Boolean htmlEscaped;
    private final UrlMode urlMode;
    private final Map<String, Object> data;

    private RenderContext(Builder builder) {
        this.hardwrap = builder.hardwrap;
        this.htmlEscaped = builder.htmlEscaped;
        this.includeHeadingId = builder.includeHeadingId;
        this.urlMode = builder.urlMode;
        this.data = ImmutableMap.copyOf(builder.data);
    }

    @Nonnull
    public Map<String, Object> getData() {
        return this.data;
    }

    @Nullable
    public Boolean getHardwrap() {
        return this.hardwrap;
    }

    @Nullable
    public Boolean getHtmlEscaped() {
        return this.htmlEscaped;
    }

    @Nullable
    public Boolean getIncludeHeadingId() {
        return this.includeHeadingId;
    }

    @Nonnull
    public UrlMode getUrlMode() {
        return this.urlMode;
    }

    public static class Builder {
        private final Map<String, Object> data;
        private Boolean hardwrap;
        private Boolean htmlEscaped;
        private Boolean includeHeadingId;
        private UrlMode urlMode;

        public Builder() {
            this.urlMode = UrlMode.RELATIVE;
            this.data = new HashMap<String, Object>();
        }

        public Builder(@Nonnull RenderContext context) {
            Objects.requireNonNull(context, "context");
            this.data = new HashMap<String, Object>(context.getData());
            this.hardwrap = context.getHardwrap();
            this.htmlEscaped = context.getHtmlEscaped();
            this.includeHeadingId = context.getIncludeHeadingId();
            this.urlMode = context.getUrlMode();
        }

        @Nonnull
        public RenderContext build() {
            return new RenderContext(this);
        }

        @Nonnull
        public Builder clearData() {
            this.data.clear();
            return this;
        }

        @Nonnull
        public Builder data(@Nonnull Map<String, Object> value) {
            this.data.putAll(Objects.requireNonNull(value, "data"));
            return this;
        }

        @Nonnull
        public Builder hardwrap(boolean value) {
            this.hardwrap = value;
            return this;
        }

        @Nonnull
        public Builder hardwrap(@Nullable Boolean value) {
            this.hardwrap = value;
            return this;
        }

        @Nonnull
        public Builder htmlEscape(boolean value) {
            this.htmlEscaped = value;
            return this;
        }

        @Nonnull
        public Builder htmlEscape(Boolean value) {
            this.htmlEscaped = value;
            return this;
        }

        @Nonnull
        public Builder includeHeadingId(boolean value) {
            this.includeHeadingId = value;
            return this;
        }

        @Nonnull
        public Builder includeHeadingId(Boolean value) {
            this.includeHeadingId = value;
            return this;
        }

        @Nonnull
        public Builder urlMode(@Nonnull UrlMode value) {
            this.urlMode = Objects.requireNonNull(value, "urlMode");
            return this;
        }
    }
}

