/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.mesh;

import com.atlassian.bitbucket.mesh.MeshNode;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;

public class UpdateMeshNodeRequest {
    private final long id;
    private final String name;
    private final String rpcUrl;
    private final MeshNode.State state;

    private UpdateMeshNodeRequest(Builder builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.rpcUrl = builder.rpcUrl;
        this.state = builder.state;
    }

    public long getId() {
        return this.id;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getRpcUrl() {
        return this.rpcUrl;
    }

    @Nullable
    public MeshNode.State getState() {
        return this.state;
    }

    public static class Builder {
        private final long id;
        private String name;
        private String rpcUrl;
        private MeshNode.State state;

        public Builder(@Nonnull MeshNode node) {
            this(Objects.requireNonNull(node, "node").getId());
        }

        public Builder(long id) {
            this.id = id;
        }

        @Nonnull
        public UpdateMeshNodeRequest build() {
            return new UpdateMeshNodeRequest(this);
        }

        @Nonnull
        public Builder name(@Nonnull String value) {
            this.name = Objects.requireNonNull(value, "name");
            return this;
        }

        @Nonnull
        public Builder rpcUrl(@Nonnull String value) {
            this.rpcUrl = Objects.requireNonNull(value, "rpcUrl");
            return this;
        }

        @Nonnull
        public Builder state(@Nonnull MeshNode.State value) {
            this.state = Objects.requireNonNull(value, "state");
            return this;
        }
    }
}

