/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.migration;

import com.atlassian.bitbucket.migration.RepositoriesExportRequest;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Optional;

public class ExportRequest {
    private final String exportLocation;
    private final RepositoriesExportRequest repositoriesRequest;

    private ExportRequest(@Nonnull Builder builder) {
        this.exportLocation = builder.exportLocation;
        this.repositoriesRequest = builder.repositoriesRequest;
    }

    @Nonnull
    public Optional<String> getExportLocation() {
        return Optional.ofNullable(this.exportLocation);
    }

    @Nonnull
    public RepositoriesExportRequest getRepositoriesRequest() {
        return this.repositoriesRequest;
    }

    public static class Builder {
        private String exportLocation;
        private RepositoriesExportRequest repositoriesRequest;

        @Nonnull
        public ExportRequest build() {
            if (this.repositoriesRequest == null) {
                throw new IllegalStateException("Repository request is required");
            }
            return new ExportRequest(this);
        }

        @Nonnull
        public Builder exportLocation(String value) {
            this.exportLocation = value;
            return this;
        }

        @Nonnull
        public Builder repositoriesRequest(@Nonnull RepositoriesExportRequest value) {
            this.repositoriesRequest = Objects.requireNonNull(value, "repositoriesRequest");
            return this;
        }
    }
}

