/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.migration;

import com.atlassian.bitbucket.validation.annotation.RequiredString;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public class ImportRequest {
    private final String archivePath;

    private ImportRequest(@Nonnull Builder builder) {
        this.archivePath = builder.archivePath;
    }

    @RequiredString
    public String getArchivePath() {
        return this.archivePath;
    }

    public static class Builder {
        private String archivePath;

        @Nonnull
        public ImportRequest build() {
            if (this.archivePath == null) {
                throw new IllegalStateException("archivePath is required");
            }
            return new ImportRequest(this);
        }

        @Nonnull
        public Builder archivePath(@Nonnull String value) {
            this.archivePath = Objects.requireNonNull(value, "value");
            return this;
        }
    }
}

