/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.migration;

import com.atlassian.bitbucket.util.BuilderSupport;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Set;

public class MeshMigrationRequest {
    private final boolean all;
    private final Set<Integer> projectIds;
    private final Set<Integer> repositoryIds;

    private MeshMigrationRequest(@Nonnull Builder builder) {
        this.all = builder.all;
        this.projectIds = builder.projectIds.build();
        this.repositoryIds = builder.repositoryIds.build();
    }

    @Nonnull
    public Set<Integer> getProjectIds() {
        return this.projectIds;
    }

    @Nonnull
    public Set<Integer> getRepositoryIds() {
        return this.repositoryIds;
    }

    public boolean isAll() {
        return this.all;
    }

    public static class Builder
    extends BuilderSupport {
        private final ImmutableSet.Builder<Integer> projectIds = new ImmutableSet.Builder();
        private final ImmutableSet.Builder<Integer> repositoryIds = new ImmutableSet.Builder();
        private boolean all;

        @Nonnull
        public Builder all(boolean value) {
            this.all = value;
            return this;
        }

        @Nonnull
        public MeshMigrationRequest build() {
            return new MeshMigrationRequest(this);
        }

        @Nonnull
        public Builder projectId(int value) {
            this.projectIds.add((Object)value);
            return this;
        }

        @Nonnull
        public Builder projectIds(@Nonnull Iterable<Integer> values) {
            Builder.addIf(Objects::nonNull, this.projectIds, values);
            return this;
        }

        @Nonnull
        public Builder repositoryId(int value) {
            this.repositoryIds.add((Object)value);
            return this;
        }

        @Nonnull
        public Builder repositoryIds(@Nonnull Iterable<Integer> values) {
            Builder.addIf(Objects::nonNull, this.repositoryIds, values);
            return this;
        }
    }
}

