/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.migration;

import com.atlassian.bitbucket.repository.Repository;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public class RepositorySelector {
    private final String projectKey;
    private final String slug;

    private RepositorySelector(Builder builder) {
        this.projectKey = builder.projectKey;
        this.slug = builder.slug;
    }

    @Nonnull
    public static RepositorySelector of(@Nonnull String projectKey, @Nonnull String slug) {
        return new Builder(projectKey, slug).build();
    }

    @Nonnull
    public static RepositorySelector of(@Nonnull Repository repository) {
        Objects.requireNonNull(repository, "repository");
        return new Builder(repository.getProject().getKey(), repository.getSlug()).build();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof RepositorySelector) {
            RepositorySelector p = (RepositorySelector)o;
            return Objects.equals(this.projectKey, p.projectKey) && Objects.equals(this.slug, p.slug);
        }
        return false;
    }

    @Nonnull
    public String getProjectKey() {
        return this.projectKey;
    }

    @Nonnull
    public String getSlug() {
        return this.slug;
    }

    public int hashCode() {
        return Objects.hash(this.projectKey, this.slug);
    }

    public static final class Builder {
        private final String projectKey;
        private final String slug;

        public Builder(@Nonnull String projectKey, @Nonnull String slug) {
            this.projectKey = Objects.requireNonNull(projectKey, "projectKey");
            this.slug = Objects.requireNonNull(slug, "slug");
            if (projectKey.equals("*") && slug.equals("*")) {
                return;
            }
            if (projectKey.equals("*") && !slug.equals("*")) {
                throw new IllegalArgumentException(String.format("Invalid repository slug: '%s'. Repository slug should be '*', if project key is '*'.", slug));
            }
            if (projectKey.contains("*")) {
                throw new IllegalArgumentException(String.format("Partial matches are not supported in project key: '%s'.", projectKey));
            }
            if (!slug.equals("*") && slug.contains("*")) {
                throw new IllegalArgumentException(String.format("Partial matches are not supported in repository slug: '%s'.", slug));
            }
        }

        @Nonnull
        public RepositorySelector build() {
            return new RepositorySelector(this);
        }
    }
}

