/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.project;

import com.atlassian.bitbucket.project.ProjectType;
import com.atlassian.bitbucket.project.ProjectVisitor;
import com.atlassian.bitbucket.validation.annotation.OptionalString;
import com.atlassian.bitbucket.validation.annotation.RequiredString;
import com.atlassian.bitbucket.validation.groups.Create;
import com.atlassian.bitbucket.validation.groups.TrustedCreate;
import com.atlassian.bitbucket.validation.groups.TrustedUpdate;
import com.atlassian.bitbucket.validation.groups.Update;
import jakarta.annotation.Nonnull;
import jakarta.validation.constraints.Pattern;

public interface Project {
    public static final String KEY_REGEXP = "[a-zA-Z][a-zA-Z0-9_\\-]*";
    public static final String KEY_TRUSTED_REGEXP = "~[a-zA-Z0-9\\-_.]+|[a-zA-Z][a-zA-Z0-9_\\-]*";
    public static final int MAX_KEY_LENGTH = 128;
    public static final int MAX_NAME_LENGTH = 128;
    public static final String NAME_REGEXP = "^[^~].*";

    public <T> T accept(@Nonnull ProjectVisitor<T> var1);

    @OptionalString(size=255)
    public String getDescription();

    public int getId();

    public boolean isPublic();

    @Pattern.List(value={@Pattern(regexp="[a-zA-Z][a-zA-Z0-9_\\-]*", groups={Create.class, Update.class}, message="{com.atlassian.bitbucket.validation.project.key.pattern.message}"), @Pattern(regexp="~[a-zA-Z0-9\\-_.]+|[a-zA-Z][a-zA-Z0-9_\\-]*", groups={TrustedCreate.class, TrustedUpdate.class}, message="{com.atlassian.bitbucket.validation.project.key.trusted.pattern.message}")})
    @RequiredString(size=128)
    public @Pattern.List(value={@Pattern(regexp="[a-zA-Z][a-zA-Z0-9_\\-]*", groups={Create.class, Update.class}, message="{com.atlassian.bitbucket.validation.project.key.pattern.message}"), @Pattern(regexp="~[a-zA-Z0-9\\-_.]+|[a-zA-Z][a-zA-Z0-9_\\-]*", groups={TrustedCreate.class, TrustedUpdate.class}, message="{com.atlassian.bitbucket.validation.project.key.trusted.pattern.message}")}) String getKey();

    @Pattern(regexp="^[^~].*", groups={Create.class, Update.class}, message="{com.atlassian.bitbucket.validation.project.name.pattern.message}")
    @RequiredString(size=128)
    public @Pattern(regexp="^[^~].*", groups={Create.class, Update.class}, message="{com.atlassian.bitbucket.validation.project.name.pattern.message}") String getName();

    @Nonnull
    public ProjectType getType();
}

