/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pull;

import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.util.BuilderSupport;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public class AbstractPullRequestRequest {
    private final long pullRequestId;
    private final int repositoryId;

    protected AbstractPullRequestRequest(@Nonnull AbstractBuilder<?> builder) {
        this.pullRequestId = builder.pullRequestId;
        this.repositoryId = builder.repositoryId;
    }

    public long getPullRequestId() {
        return this.pullRequestId;
    }

    public int getRepositoryId() {
        return this.repositoryId;
    }

    public static abstract class AbstractBuilder<T extends AbstractBuilder<T>>
    extends BuilderSupport {
        private final long pullRequestId;
        private final int repositoryId;

        protected AbstractBuilder(@Nonnull PullRequest pullRequest) {
            this(Objects.requireNonNull(pullRequest, "pullRequest").getToRef().getRepository().getId(), pullRequest.getId());
        }

        protected AbstractBuilder(int repositoryId, long pullRequestId) {
            this.repositoryId = repositoryId;
            this.pullRequestId = pullRequestId;
        }

        @Nonnull
        protected abstract T self();
    }
}

