/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pull;

import com.atlassian.bitbucket.pull.PullRequestState;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.Set;

public class PullRequestCommitSearchRequest {
    private final String commitId;
    private final Set<PullRequestState> states;
    private final Integer toRepositoryId;

    private PullRequestCommitSearchRequest(Builder builder) {
        this.commitId = builder.commitId;
        this.states = builder.states.build();
        this.toRepositoryId = builder.toRepositoryId;
    }

    @Nonnull
    public String getCommitId() {
        return this.commitId;
    }

    @Nonnull
    public Set<PullRequestState> getStates() {
        return this.states;
    }

    @Nullable
    public Integer getToRepositoryId() {
        return this.toRepositoryId;
    }

    public static class Builder
    extends BuilderSupport {
        private final String commitId;
        private final ImmutableSet.Builder<PullRequestState> states;
        private Integer toRepositoryId;

        public Builder(@Nonnull String commitId) {
            this.commitId = Builder.requireNonBlank(commitId, "commitId");
            this.states = ImmutableSet.builder();
        }

        @Nonnull
        public PullRequestCommitSearchRequest build() {
            return new PullRequestCommitSearchRequest(this);
        }

        @Nonnull
        public Builder state(@Nullable PullRequestState value) {
            Builder.addIf(Objects::nonNull, this.states, value);
            return this;
        }

        @Nonnull
        public Builder states(@Nullable Iterable<PullRequestState> values) {
            Builder.addIf(Objects::nonNull, this.states, values);
            return this;
        }

        @Nonnull
        public Builder states(@Nullable PullRequestState value, PullRequestState ... values) {
            Builder.addIf(Objects::nonNull, this.states, value, values);
            return this;
        }

        @Nonnull
        public Builder toRepositoryId(@Nullable Integer toRepositoryId) {
            this.toRepositoryId = toRepositoryId;
            return this;
        }
    }
}

