/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pull;

import com.atlassian.bitbucket.pull.AbstractPullRequestRequest;
import com.atlassian.bitbucket.pull.PullRequest;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Set;

public class PullRequestCommitsRequest
extends AbstractPullRequestRequest {
    private final int maxMessageLength;
    private final Set<String> propertyKeys;

    private PullRequestCommitsRequest(Builder builder) {
        super(builder);
        this.maxMessageLength = builder.maxMessageLength;
        this.propertyKeys = builder.propertyKeys.build();
    }

    public int getMaxMessageLength() {
        return this.maxMessageLength;
    }

    @Nonnull
    public Set<String> getPropertyKeys() {
        return this.propertyKeys;
    }

    public static class Builder
    extends AbstractPullRequestRequest.AbstractBuilder<Builder> {
        private final ImmutableSet.Builder<String> propertyKeys = ImmutableSet.builder();
        private int maxMessageLength = -1;

        public Builder(@Nonnull PullRequest pullRequest) {
            super(pullRequest);
        }

        public Builder(int repositoryId, long pullRequestId) {
            super(repositoryId, pullRequestId);
        }

        @Nonnull
        public PullRequestCommitsRequest build() {
            return new PullRequestCommitsRequest(this);
        }

        @Nonnull
        public Builder maxMessageLength(int value) {
            this.maxMessageLength = value;
            return this.self();
        }

        @Nonnull
        public Builder propertyKey(@Nullable String value) {
            Builder.addIf(NOT_BLANK, this.propertyKeys, value);
            return this.self();
        }

        @Nonnull
        public Builder propertyKeys(@Nullable Iterable<String> values) {
            Builder.addIf(NOT_BLANK, this.propertyKeys, values);
            return this.self();
        }

        @Nonnull
        public Builder propertyKeys(@Nullable String value, String ... values) {
            Builder.addIf(NOT_BLANK, this.propertyKeys, value, values);
            return this.self();
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

