/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pull;

import com.atlassian.bitbucket.comment.CommentThreadDiffAnchorType;
import com.atlassian.bitbucket.content.DiffContentFilter;
import com.atlassian.bitbucket.content.DiffWhitespace;
import com.atlassian.bitbucket.pull.AbstractPullRequestRequest;
import com.atlassian.bitbucket.pull.PullRequest;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class PullRequestDiffRequest
extends AbstractPullRequestRequest {
    public static final int DEFAULT_CONTEXT_LINES = -1;
    private final int contextLines;
    private final CommentThreadDiffAnchorType diffType;
    private final DiffContentFilter filter;
    private final String path;
    private final String sinceId;
    private final String srcPath;
    private final String untilId;
    private final DiffWhitespace whitespace;
    private final boolean withComments;

    private PullRequestDiffRequest(Builder builder) {
        super(builder);
        this.contextLines = builder.contextLines;
        this.diffType = builder.diffType;
        this.filter = builder.filter;
        this.path = builder.path;
        this.sinceId = builder.sinceId;
        this.srcPath = builder.srcPath;
        this.untilId = builder.untilId;
        this.whitespace = builder.whitespace;
        this.withComments = builder.withComments;
    }

    public int getContextLines() {
        return this.contextLines;
    }

    @Nullable
    public CommentThreadDiffAnchorType getDiffType() {
        return this.diffType;
    }

    @Nullable
    public DiffContentFilter getFilter() {
        return this.filter;
    }

    @Nullable
    public String getPath() {
        return this.path;
    }

    @Nullable
    public String getSinceId() {
        return this.sinceId;
    }

    @Nullable
    public String getSrcPath() {
        return this.srcPath;
    }

    @Nullable
    public String getUntilId() {
        return this.untilId;
    }

    @Nonnull
    public DiffWhitespace getWhitespace() {
        return this.whitespace;
    }

    public boolean hasContextLines() {
        return this.contextLines > -1;
    }

    public boolean isWithComments() {
        return this.withComments;
    }

    public static class Builder
    extends AbstractPullRequestRequest.AbstractBuilder<Builder> {
        private final String path;
        private int contextLines;
        private CommentThreadDiffAnchorType diffType;
        private DiffContentFilter filter;
        private String sinceId;
        private String srcPath;
        private String untilId;
        private DiffWhitespace whitespace;
        private boolean withComments;

        public Builder(@Nonnull PullRequestDiffRequest request) {
            super(Objects.requireNonNull(request, "request").getRepositoryId(), request.getPullRequestId());
            this.contextLines = request.getContextLines();
            this.diffType = request.diffType;
            this.filter = request.getFilter();
            this.path = request.getPath();
            this.sinceId = request.sinceId;
            this.srcPath = StringUtils.trimToNull((String)request.getSrcPath());
            this.untilId = request.untilId;
            this.whitespace = Objects.requireNonNull(request.getWhitespace(), "request.whitespace");
            this.withComments = request.isWithComments();
        }

        public Builder(@Nonnull PullRequest pullRequest, @Nullable String path) {
            this(Objects.requireNonNull(pullRequest, "pullRequest").getToRef().getRepository().getId(), pullRequest.getId(), path);
        }

        public Builder(int repositoryId, long pullRequestId, @Nullable String path) {
            super(repositoryId, pullRequestId);
            this.path = path;
            this.contextLines = -1;
            this.whitespace = DiffWhitespace.SHOW;
            this.withComments = true;
        }

        @Nonnull
        public PullRequestDiffRequest build() {
            return new PullRequestDiffRequest(this);
        }

        @Nonnull
        public Builder contextLines(int value) {
            this.contextLines = Math.max(-1, value);
            return this.self();
        }

        @Nonnull
        public Builder diffType(@Nullable CommentThreadDiffAnchorType value) {
            this.diffType = value;
            return this.self();
        }

        @Nonnull
        public Builder filter(@Nullable DiffContentFilter value) {
            this.filter = value;
            return this.self();
        }

        @Nonnull
        public Builder sinceId(@Nullable String value) {
            this.sinceId = value;
            return this.self();
        }

        @Nonnull
        public Builder srcPath(@Nullable String value) {
            this.srcPath = StringUtils.trimToNull((String)value);
            return this.self();
        }

        @Nonnull
        public Builder untilId(@Nonnull String value) {
            this.untilId = value;
            return this.self();
        }

        @Nonnull
        public Builder whitespace(@Nonnull DiffWhitespace value) {
            this.whitespace = Objects.requireNonNull(value, "whitespace");
            return this.self();
        }

        @Nonnull
        public Builder withComments(boolean value) {
            this.withComments = value;
            return this.self();
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

