/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pull;

import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestParticipantStatus;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;

public class PullRequestFinishReviewRequest {
    private final String commentText;
    private final String lastReviewedCommit;
    private final PullRequestParticipantStatus participantStatus;
    private final PullRequest pullRequest;

    private PullRequestFinishReviewRequest(@Nonnull Builder builder) {
        this.commentText = builder.commentText;
        this.lastReviewedCommit = builder.lastReviewedCommit;
        this.participantStatus = builder.participantStatus;
        this.pullRequest = builder.pullRequest;
    }

    @Nullable
    public String getCommentText() {
        return this.commentText;
    }

    @Nullable
    public String getLastReviewedCommit() {
        return this.lastReviewedCommit;
    }

    @Nullable
    public PullRequestParticipantStatus getParticipantStatus() {
        return this.participantStatus;
    }

    @Nonnull
    public PullRequest getPullRequest() {
        return this.pullRequest;
    }

    public static class Builder {
        private final PullRequest pullRequest;
        private String commentText;
        private String lastReviewedCommit;
        private PullRequestParticipantStatus participantStatus;

        public Builder(@Nonnull PullRequest pullRequest) {
            this.pullRequest = Objects.requireNonNull(pullRequest, "pullRequest");
        }

        @Nonnull
        public PullRequestFinishReviewRequest build() {
            return new PullRequestFinishReviewRequest(this);
        }

        @Nonnull
        public Builder commentText(@Nullable String value) {
            this.commentText = value;
            return this;
        }

        @Nonnull
        public Builder lastReviewedCommit(@Nullable String value) {
            this.lastReviewedCommit = value;
            return this;
        }

        @Nonnull
        public Builder participantStatus(@Nullable PullRequestParticipantStatus value) {
            this.participantStatus = value;
            return this;
        }
    }
}

